//*********************************************************
//
// Copyright (c) Microsoft. All rights reserved.
// This code is licensed under the MIT License (MIT).
// THIS CODE IS PROVIDED *AS IS* WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING ANY
// IMPLIED WARRANTIES OF FITNESS FOR A PARTICULAR
// PURPOSE, MERCHANTABILITY, OR NON-INFRINGEMENT.
//
//*********************************************************

#include "stdafx.h"
#include "Win32Application.h"
#include "strsafe.h"

#include <iostream>
#include <string>
#include <fstream>
#include <sstream>

int Win32Application_Main::Nucleosome_position[Nucleosome_amount];
int Win32Application_Main::Nucleosome_chromosome[Nucleosome_amount];

HWND Win32Application_3D::m_hwnd = nullptr;
HWND Win32Application_Main::hWnd = nullptr;

INT_PTR CALLBACK    About(HWND, UINT, WPARAM, LPARAM);


int Win32Application_3D::Run(DXSample* pSample, HINSTANCE hInstance, int nCmdShow)
{
	// Parse the command line parameters
	int argc;
	LPWSTR* argv = CommandLineToArgvW(GetCommandLineW(), &argc);
	pSample->ParseCommandLineArgs(argv, argc);
	LocalFree(argv);

	// Initialize the window class.
	WNDCLASSEX windowClass = { 0 };
	windowClass.cbSize = sizeof(WNDCLASSEX);
	windowClass.style = CS_HREDRAW | CS_VREDRAW;
	windowClass.lpfnWndProc = WindowProc;
	windowClass.hInstance = hInstance;
	windowClass.hCursor = LoadCursor(NULL, IDC_ARROW);
	windowClass.lpszClassName = L"DXSampleClass";
	RegisterClassEx(&windowClass);

	RECT windowRect = { 0, 0, static_cast<LONG>(pSample->GetWidth()), static_cast<LONG>(pSample->GetHeight()) };
	AdjustWindowRect(&windowRect, WS_OVERLAPPEDWINDOW, FALSE);

	// Create the window and store a handle to it.
	m_hwnd = CreateWindow(
		windowClass.lpszClassName,
		pSample->GetTitle(),
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		windowRect.right - windowRect.left,
		windowRect.bottom - windowRect.top,
		nullptr,		// We have no parent window.
		nullptr,		// We aren't using menus.
		hInstance,
		pSample);

	// Initialize the sample. OnInit is defined in each child-implementation of DXSample.
	pSample->OnInit();

	ShowWindow(m_hwnd, nCmdShow);

	// Main sample loop.
	MSG msg = {};
	while (msg.message != WM_QUIT)
	{
		// Process any messages in the queue.
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	pSample->OnDestroy();

	// Return this part of the WM_QUIT message to Windows.
	return static_cast<char>(msg.wParam);
}

// Main message handler for the sample.
LRESULT CALLBACK Win32Application_3D::WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	DXSample* pSample = reinterpret_cast<DXSample*>(GetWindowLongPtr(hWnd, GWLP_USERDATA));

	switch (message)
	{




	case WM_CREATE:
		{
			// Save the DXSample* passed in to CreateWindow.
			LPCREATESTRUCT pCreateStruct = reinterpret_cast<LPCREATESTRUCT>(lParam);
			SetWindowLongPtr(hWnd, GWLP_USERDATA, reinterpret_cast<LONG_PTR>(pCreateStruct->lpCreateParams));
		}
		return 0;

	case WM_KEYDOWN:
		if (pSample)
		{
			
			pSample->OnKeyDown(static_cast<UINT8>(wParam));
		}
		
		return 0;

	case WM_KEYUP:
		if (pSample)
		{
			pSample->OnKeyUp(static_cast<UINT8>(wParam));
		}
		return 0;

	case WM_PAINT:
		if (pSample)
		{
			pSample->OnUpdate();
			pSample->OnRender();
		}
		return 0;

	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}

	// Handle any messages the switch statement didn't.
	return DefWindowProc(hWnd, message, wParam, lParam);
}


const int Chromosome_position_display_length = 1000;
TCHAR Chromosome_sequence_display[Chromosome_position_display_length];
TCHAR Chromosome_position_display[Chromosome_position_display_length];
TCHAR Nucleosome_position_display[Chromosome_position_display_length];
TCHAR Nucleosome_Chro_number_display[Chromosome_position_display_length];
TCHAR Gene_position_display[Chromosome_position_display_length];

HWND hListBox;
HWND hTextBox;
HWND NucleosomeTextBox;

int Win32Application_Main::Run_Main(HINSTANCE hInstance, int nCmdShow)
{

	static TCHAR szWindowClass[] = _T("win32app");                       
	static TCHAR szTitle[] = _T("Yeast Nucleosome");			 

	HINSTANCE hInst;

	WNDCLASSEX wcex; wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.style = CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc = WndProc;
	wcex.cbClsExtra = 0;
	wcex.cbWndExtra = 0;
	wcex.hInstance = hInstance;
	wcex.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APPLICATION));
	wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
	wcex.lpszMenuName = MAKEINTRESOURCEW(IDR_MENU1);
	wcex.lpszClassName = szWindowClass;
	wcex.hIconSm = LoadIcon(wcex.hInstance, MAKEINTRESOURCE(IDI_APPLICATION));

	if (!RegisterClassEx(&wcex))
	{
		MessageBox(NULL, _T("Call to RegisterClassEx failed!"), _T("Win32 Guided Tour"), NULL);
		return 1;
	}
	hInst = hInstance;

	// Create the window and store a handle to it.
	hWnd = CreateWindowW(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW | WS_HSCROLL | WS_VSCROLL,
		CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

	HWND hwndButton = CreateWindowW(
		L"BUTTON",  // Predefined class; Unicode assumed 
		L"Display",      // Button text 
		WS_TABSTOP | WS_VISIBLE | WS_CHILD | BS_DEFPUSHBUTTON,  // Styles 
		10,         // x position 
		400,         // y position 
		100,        // Button width
		50,        // Button height
		hWnd,     // Parent window
		(HMENU)222,       // No menu.
		NULL,
		NULL);

	hListBox = CreateWindowExW(
		WS_EX_CLIENTEDGE, 
		L"LISTBOX", 
		NULL, 
		WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL | BS_DEFPUSHBUTTON,
		400,
		250,
		300,
		270, 
		hWnd, 
		(HMENU)224,
		hInstance, 
		NULL);

	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 1");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 2");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 3");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 4");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 5");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 6");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 7");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 8");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 9");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 10");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 11");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 12");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 13");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 14");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 15");
	SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)L"Chromosome 16");

	
	hTextBox = CreateWindowExW(
		 WS_EX_CLIENTEDGE, L"EDIT", NULL, WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL, 
		 750,
		 300,
		 200,
		 21,
		 hWnd,
		 (HMENU)225,
		 hInstance,
		 NULL);

	NucleosomeTextBox = CreateWindowExW(
		WS_EX_CLIENTEDGE, L"STATIC", L"Chromosome Position", WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL,
		750,
		340,
		200,
		21,
		hWnd,
		(HMENU)227,
		hInstance,
		NULL);

	NucleosomeTextBox = CreateWindowExW(
		WS_EX_CLIENTEDGE, L"STATIC", L"Chromosome Position", WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL,
		10,
		340,
		200,
		21,
		hWnd,
		(HMENU)227,
		hInstance,
		NULL);

	NucleosomeTextBox = CreateWindowExW(
		WS_EX_CLIENTEDGE, L"STATIC", L"A: DNA sequence", WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL,
		10,
		130,
		200,
		21,
		hWnd,
		(HMENU)227,
		hInstance,
		NULL);
	NucleosomeTextBox = CreateWindowExW(
		WS_EX_CLIENTEDGE, L"STATIC", L"B: Chromosome Position", WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL,
		10,
		160,
		200,
		21,
		hWnd,
		(HMENU)227,
		hInstance,
		NULL);

	NucleosomeTextBox = CreateWindowExW(
		WS_EX_CLIENTEDGE, L"STATIC", L"C: Nucleosome", WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL,
		10,
		190,
		200,
		21,
		hWnd,
		(HMENU)227,
		hInstance,
		NULL);

	NucleosomeTextBox = CreateWindowExW(
		WS_EX_CLIENTEDGE, L"STATIC", L"D: Nucleosome Number", WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL,
		10,
		220,
		200,
		21,
		hWnd,
		(HMENU)227,
		hInstance,
		NULL);

	NucleosomeTextBox = CreateWindowExW(
		WS_EX_CLIENTEDGE, L"EDIT", NULL, WS_CHILD | WS_VISIBLE | ES_AUTOVSCROLL,
		10,
		300,
		200,
		21,
		hWnd,
		(HMENU)226,
		hInstance,
		NULL);

	if (!hWnd)
	{
		MessageBox(NULL, _T("Call to CreateWindow failed!"), _T("Win32 Guided Tour"), NULL);
		return 1;
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);
	
	MSG msg;

	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg); DispatchMessage(&msg);
	}

	return (int)msg.wParam;
}



LRESULT CALLBACK Win32Application_Main::WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) 
{
	
	
	PAINTSTRUCT ps; 
	HDC hdc; 

	TEXTMETRIC tm;
	SCROLLINFO si;

	static int xClient;     // width of client area 
	static int yClient;     // height of client area 
	static int xClientMax;  // maximum width of client area 

	static int xChar;       // horizontal scrolling unit 
	static int yChar;       // vertical scrolling unit 
	static int xUpper;      // average width of uppercase letters 

	static int xPos;        // current horizontal scrolling position 
	static int yPos;        // current vertical scrolling position 

	int i;                  // loop counter 
	int x, y;               // horizontal and vertical coordinates

	int FirstLine;          // first line in the invalidated area 
	int LastLine;           // last line in the invalidated area 
	HRESULT hr;
	size_t abcLength;        // length of an abc[] item 

#define LINES 28 

	switch (message)
	{
	case WM_COMMAND:
	{
		if (LOWORD(wParam) == 222)
		{
			Atom_color::Nucleosome_number = 0;

			TCHAR buffer[256] = { 0 };
			if (GetWindowText(NucleosomeTextBox, buffer, 256)) // will return 0 on failure
			{
				Atom_color::Nucleosome_number = _wtoi(buffer);
			}
			Yucleosome3D sample(1280, 720, L"Yucleosome DNA-Histone of yeast");
			Win32Application_3D::Run(&sample, NULL, SW_SHOW);
		}


		if (LOWORD(wParam) == 223)
		{
			TCHAR Position_Cursor [12];
			std::string point_tmp;
			GetCursorPos(&SimpleCamera::point);
			ScreenToClient(Win32Application_Main::hWnd, &SimpleCamera::point);
			point_tmp = std::to_string(SimpleCamera::point.x);
			
			int point_tmp_length = point_tmp.length();
			int i5;
			for (i5 = 0;i5 < point_tmp_length;i5++)
			{
				Position_Cursor[i5] = point_tmp[i5];
			}
			Position_Cursor[i5]= '\0';
			MessageBox(NULL, Position_Cursor, _T("TEST"), NULL);
		}

		if (LOWORD(wParam) == 224)
		{
			int chromo_pos=0;
			TCHAR buffer[256] = { 0 };
			if (GetWindowText(hTextBox, buffer, 256)) // will return 0 on failure
			{
				chromo_pos = _wtoi(buffer);
			}

			LRESULT SelIndex = SendMessage(hListBox, LB_GETCURSEL, 0, 0);
			if (SelIndex != LB_ERR)
			{
				switch (SelIndex)
				{
				case 0:
					Data_selection::Sequence_selection("01", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 1:
					Data_selection::Sequence_selection("02", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 2:
					Data_selection::Sequence_selection("03", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 3:
					Data_selection::Sequence_selection("04", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 4:
					Data_selection::Sequence_selection("05", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 5:
					Data_selection::Sequence_selection("06", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 6:
					Data_selection::Sequence_selection("07", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 7:
					Data_selection::Sequence_selection("08", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 8:
					Data_selection::Sequence_selection("09", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 9:
					Data_selection::Sequence_selection("10", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 10:
					Data_selection::Sequence_selection("11", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 11:
					Data_selection::Sequence_selection("12", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 12:
					Data_selection::Sequence_selection("13", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 13:
					Data_selection::Sequence_selection("14", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 14:
					Data_selection::Sequence_selection("15", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				case 15:
					Data_selection::Sequence_selection("16", chromo_pos);
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				default:
					InvalidateRect(hWnd, NULL, NULL);
					UpdateWindow(hWnd);
					break;
				}
			}
		}

	
		int wmId = LOWORD(wParam);
		// Parse the menu selections:
		switch (wmId)
		{
		case ID_ABOUT_ABOUT:
			MessageBox(NULL, _T("Yucleosome Version 1.0.0\r\nCopyright (C) 2017\r\nOliver Blechert"), _T("About"), NULL);
			break;
		case ID_ABOUT_COPYRIGHT:
			MessageBox(NULL, _T("Copyright <2017> <Oliver Blechert>\r\n\r\nPermission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files(the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and / or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions :\r\nThe above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.\r\n\r\nTHE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE."), _T("Copyright"), NULL);
			break;

		case ID_FIKE_QUIT:
			DestroyWindow(hWnd);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
	}
	break;

	case WM_CREATE:

		// Get the handle to the client area's device context. 
		hdc = GetDC(hWnd);

		// Extract font dimensions from the text metrics. 
		GetTextMetrics(hdc, &tm);
		xChar = tm.tmAveCharWidth;
		xUpper = (tm.tmPitchAndFamily & 1 ? 3 : 2) * xChar / 2;
		yChar = tm.tmHeight + tm.tmExternalLeading;

		// Free the device context. 
		ReleaseDC(hWnd, hdc);

		// Set an arbitrary maximum width for client area. 
		// (xClientMax is the sum of the widths of 48 average 
		// lowercase letters and 12 uppercase letters.) 
		xClientMax = Chromosome_position_display_length * xChar + 12 * xUpper;

		return 0;

		break;


	case WM_SIZE:

		// Retrieve the dimensions of the client area. 
		yClient = HIWORD(lParam);
		xClient = LOWORD(lParam);

		// Set the vertical scrolling range and page size
		si.cbSize = sizeof(si);
		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = LINES - 1;
		si.nPage = yClient / yChar;
		SetScrollInfo(hWnd, SB_VERT, &si, TRUE);

		// Set the horizontal scrolling range and page size. 
		si.cbSize = sizeof(si);
		si.fMask = SIF_RANGE | SIF_PAGE;
		si.nMin = 0;
		si.nMax = 2 + xClientMax / xChar;
		si.nPage = xClient / xChar;
		SetScrollInfo(hWnd, SB_HORZ, &si, TRUE);

		return 0;
	case WM_HSCROLL:
		// Get all the vertial scroll bar information.
		si.cbSize = sizeof(si);
		si.fMask = SIF_ALL;

		// Save the position for comparison later on.
		GetScrollInfo(hWnd, SB_HORZ, &si);
		xPos = si.nPos;
		switch (LOWORD(wParam))
		{
			// User clicked the left arrow.
		case SB_LINELEFT:
			si.nPos -= 1;
			break;

			// User clicked the right arrow.
		case SB_LINERIGHT:
			si.nPos += 1;
			break;

			// User clicked the scroll bar shaft left of the scroll box.
		case SB_PAGELEFT:
			si.nPos -= si.nPage;
			break;

			// User clicked the scroll bar shaft right of the scroll box.
		case SB_PAGERIGHT:
			si.nPos += si.nPage;
			break;

			// User dragged the scroll box.
		case SB_THUMBTRACK:
			si.nPos = si.nTrackPos;
			break;

		default:
			break;
		}

		// Set the position and then retrieve it.  Due to adjustments
		// by Windows it may not be the same as the value set.
		si.fMask = SIF_POS;
		SetScrollInfo(hWnd, SB_HORZ, &si, TRUE);
		GetScrollInfo(hWnd, SB_HORZ, &si);

		// If the position has changed, scroll the window.
		if (si.nPos != xPos)
		{
			ScrollWindow(hWnd, xChar * (xPos - si.nPos), 0, NULL, NULL);
		}

		return 0;

	case WM_VSCROLL:
		// Get all the vertial scroll bar information.
		si.cbSize = sizeof(si);
		si.fMask = SIF_ALL;
		GetScrollInfo(hWnd, SB_VERT, &si);

		// Save the position for comparison later on.
		yPos = si.nPos;
		switch (LOWORD(wParam))
		{

			// User clicked the HOME keyboard key.
		case SB_TOP:
			si.nPos = si.nMin;
			break;

			// User clicked the END keyboard key.
		case SB_BOTTOM:
			si.nPos = si.nMax;
			break;

			// User clicked the top arrow.
		case SB_LINEUP:
			si.nPos -= 1;
			break;

			// User clicked the bottom arrow.
		case SB_LINEDOWN:
			si.nPos += 1;
			break;

			// User clicked the scroll bar shaft above the scroll box.
		case SB_PAGEUP:
			si.nPos -= si.nPage;
			break;

			// User clicked the scroll bar shaft below the scroll box.
		case SB_PAGEDOWN:
			si.nPos += si.nPage;
			break;

			// User dragged the scroll box.
		case SB_THUMBTRACK:
			si.nPos = si.nTrackPos;
			break;

		default:
			break;
		}

		// Set the position and then retrieve it.  Due to adjustments
		// by Windows it may not be the same as the value set.
		si.fMask = SIF_POS;
		SetScrollInfo(hWnd, SB_VERT, &si, TRUE);
		GetScrollInfo(hWnd, SB_VERT, &si);

		// If the position has changed, scroll window and update it.
		if (si.nPos != yPos)
		{
			ScrollWindow(hWnd, 0, yChar * (yPos - si.nPos), NULL, NULL);
			UpdateWindow(hWnd);
		}
		return 0;

	case WM_PAINT:
	{
		hdc = BeginPaint(hWnd, &ps);
	
		HFONT hFont = CreateFont(10, 5, 0, 0, FW_DONTCARE, FALSE, FALSE, FALSE, DEFAULT_CHARSET, OUT_OUTLINE_PRECIS,
			CLIP_DEFAULT_PRECIS, ANTIALIASED_QUALITY, FIXED_PITCH, TEXT("Courier"));
		SelectObject(hdc, hFont);

		// Get vertical scroll bar position.
		si.cbSize = sizeof(si);
		si.fMask = SIF_POS;
		GetScrollInfo(hWnd, SB_VERT, &si);
		yPos = si.nPos;

		// Get horizontal scroll bar position.
		GetScrollInfo(hWnd, SB_HORZ, &si);
		xPos = si.nPos;

		// Find painting limits.
		FirstLine = max(0, yPos + ps.rcPaint.top / yChar);
		LastLine = min(LINES - 1, yPos + ps.rcPaint.bottom / yChar);

		x = xChar * (1 - xPos);
		hr = StringCchLength(Chromosome_sequence_display, Chromosome_position_display_length, &abcLength);
		if ((FAILED(hr)) | (abcLength == NULL))
		{
			//
			//
		}



		TextOut(hdc, x, 5, Chromosome_sequence_display, _tcslen(Chromosome_sequence_display));
		TextOut(hdc, x, 30, Chromosome_position_display, _tcslen(Chromosome_position_display));
		TextOut(hdc, x, 55, Nucleosome_position_display, _tcslen(Nucleosome_position_display));
		TextOut(hdc, x, 80, Nucleosome_Chro_number_display, _tcslen(Nucleosome_Chro_number_display));
		TextOut(hdc, x, 105, Gene_position_display, _tcslen(Gene_position_display));

		EndPaint(hWnd, &ps);

		
	}
	break;

	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}


// Message handler for about box.
INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	UNREFERENCED_PARAMETER(lParam);
	switch (message)
	{
	case WM_INITDIALOG:
		return (INT_PTR)TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL)
		{
			EndDialog(hDlg, LOWORD(wParam));
			return (INT_PTR)TRUE;
		}
		break;
	}
	return (INT_PTR)FALSE;
}



void Data_selection::Sequence_selection(char chro_number[2], int chromo_position_start)
{
	using namespace std;

	int chromo_pos_start = chromo_position_start;
	string chromo = (string)chro_number;
	string fileName;
	for (int i = 0; i < 16; i++)
	{
		std::stringstream stream;
		stream << "Chromosome" << chromo << ".txt";
		fileName = stream.str();
	}

	ifstream file(fileName);
	if (file.is_open())
	{
		for (int i = 0; i < chromo_pos_start; ++i)
		{
			file.get();
		}
		for (int i = 0; i < 1000; ++i)
		{
			Chromosome_sequence_display[i] = file.get();
		}
	}
	file.close();
	for (int i = 0; i < Chromosome_position_display_length; i++)
	{
		Chromosome_position_display[i]='_';
	}
	for (int i = 0; i < Chromosome_position_display_length; i++)
	{
		if ((i + chromo_pos_start) % 100 == 0)
		{
			std::string chromo_pos_index = std::to_string(i + chromo_pos_start);

			int chromo_pos_index_len = chromo_pos_index.length();

			for (int i1 = 0; i1 < chromo_pos_index_len; i1++)
			{
				if (i + i1<Chromosome_position_display_length)
				{
					Chromosome_position_display[i + i1] = chromo_pos_index[i1];
				}
			}
		}
	}
	for (int i = 0; i < Chromosome_position_display_length; i++)
	{
		Nucleosome_position_display[i] = '_';
	}

	for (int i = 0; i < Chromosome_position_display_length; i++)
	{
		Nucleosome_Chro_number_display[i] = '_';
	}

	int chromo_number_sequence;
	chromo_number_sequence=atoi(chro_number);

	for (int i = 0; i < Nucleosome_amount; i++)
	{
		if (chromo_number_sequence == Win32Application_Main::Nucleosome_chromosome[i])
		{
			for (int i5=0; i5 < Chromosome_position_display_length; i5++)

			if (chromo_pos_start + i5== Win32Application_Main::Nucleosome_position[i])
			{
				Nucleosome_position_display[i5] = 'X';

				string Nucleosome_index = to_string(i+1);

				int Nucleosome_index_len = Nucleosome_index.length();

				for (int i1 = 0; i1 < Nucleosome_index_len; i1++)
				{
					if (i5 + i1 < Chromosome_position_display_length)
					{
						Nucleosome_Chro_number_display[i5 + i1] = Nucleosome_index[i1];
					}
				}
			}
		}
	}
}

void Win32Application_Main::Nucleosome_Array()
{
	using namespace std;
	ifstream Nucleosome_file("Nucleosome.txt");
	std::string   line;


	int line_len;
	int i1 = 0;
	int i2 = 0;
	int i3 = 0;
	int i4 = 0;

	char value[12] = "333";
	while (getline(Nucleosome_file, line))
	{

		line_len = line.length();
		i2 = 0;
		i3 = 1;

		for (int i1 = 0; i1 < line_len; i1++)
		{
			if (line[i1] == '\t' && i3 == 1)
			{
				i4 = atoi(value);
				i2 = 0;
				i3 = 2;
				i1++;
			}

			if (line[i1] == '\t' && i3 == 2)
			{
				Nucleosome_chromosome[i4 - 1] = atoi(value);
				i2 = 0;
				i3 = 3;
				i1++;
			}

			if (line[i1] == '\t' && i3 == 3)
			{
				Nucleosome_position[i4 - 1] = atoi(value);
				i2 = 0;
				i3 = 4;
				i1++;
			}

			else
			{
				if (i2<10)
				{
					value[i2] = line[i1];
					value[i2 + 1] = '\0';
					i2++;
				}
			}
		}
	}
}


