//   Copyright   Oliver Blechert   2021   //

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "main_win.h"
#include "load_reference_file.h"
#include "load_sam_file.h"
#include "analyse_sam_win_choose.h"
#include "analyse_sam_win_result.h"

extern char **sequence_string;
extern char **sam_sequence;
extern int *sam_position;
extern int *sam_contig;
extern int sam_line;
extern void sam_win_result ();

  const char *text01;
  const char *text02;

int chromosome=1;
int position=1;

void input_value(GtkWidget *widget, gpointer *data) {
   char *ptr;
   chromosome=strtol(text01, &ptr, 10);
   position=strtol(text02, &ptr, 10);
   sam_win_result (); }

extern void samchoosed_win (GtkWidget *widget, gpointer data) {

   GtkWidget *window;
   GtkWidget *box;
   GtkWidget *menubar;
   GtkWidget *filemenu;
   GtkWidget *file;
   GtkWidget *open;
   GtkWidget *quit;
   GtkWidget *helpabout;
   GtkWidget *helpmenu;
   GtkWidget *help;
   GtkWidget *about;

   GtkEntryBuffer *buffer01;
   GtkEntryBuffer *buffer02;
   GtkWidget *entry01;
   GtkWidget *entry02;

   GtkWidget *view=NULL;
   GtkTextBuffer *buffer_entry;
   GtkWidget *frame01;
   GtkWidget *frame02;
   GtkWidget *bbox01;
   GtkWidget *bbox02;
   GtkWidget *button01;

   window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW (window), "YNGS");
   gtk_window_set_default_size (GTK_WINDOW (window), 800, 300);

   menubar = gtk_menu_bar_new();
   filemenu = gtk_menu_new();
   file = gtk_menu_item_new_with_label("File");
   open = gtk_menu_item_new_with_label("Open");
   quit = gtk_menu_item_new_with_label("Quit");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), filemenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(filemenu), open);
   gtk_menu_shell_append(GTK_MENU_SHELL(filemenu), quit);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), file);
   g_signal_connect_swapped (quit, "activate", G_CALLBACK (gtk_widget_destroy), window);
   helpmenu = gtk_menu_new();
   helpabout = gtk_menu_item_new_with_label("Help");
   help = gtk_menu_item_new_with_label("Help");
   about = gtk_menu_item_new_with_label("About");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(helpabout), helpmenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), help);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), about);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), helpabout);

   box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 5);
   gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, FALSE, 3);

   gtk_container_add (GTK_CONTAINER (window), box);

   frame01 = gtk_frame_new ("Chromosome");

   frame02 = gtk_frame_new ("Position");

   bbox01 = gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);
   bbox02 = gtk_button_box_new (GTK_ORIENTATION_HORIZONTAL);

   gtk_container_set_border_width (GTK_CONTAINER (bbox01), 5);
   gtk_container_set_border_width (GTK_CONTAINER (bbox02), 5);
   gtk_container_add (GTK_CONTAINER (box), frame01);
   gtk_container_add (GTK_CONTAINER (box), frame02);

   gtk_container_add (GTK_CONTAINER (frame01), bbox01);
   gtk_container_add (GTK_CONTAINER (frame02), bbox02);

   gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox01), GTK_BUTTONBOX_START);
   gtk_box_set_spacing (GTK_BOX (bbox01), 40);
   button01 = gtk_button_new_with_label (("OK"));

   gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox02), GTK_BUTTONBOX_START);
   gtk_box_set_spacing (GTK_BOX (bbox02), 40);

   buffer01 = gtk_entry_buffer_new (NULL, 0);
   entry01 = gtk_entry_new_with_buffer (buffer01);
   gtk_box_pack_start (GTK_BOX (bbox01), entry01, FALSE, FALSE, 0);

   button01=gtk_button_new_with_label("button 1");
   gtk_entry_set_text (GTK_ENTRY (entry01),"1");
   text01=gtk_entry_get_text (GTK_ENTRY (entry01));

   buffer02 = gtk_entry_buffer_new (NULL, 0);
   entry02 = gtk_entry_new_with_buffer (buffer02);
   gtk_box_pack_start (GTK_BOX (bbox02), entry02, FALSE, FALSE, 0);

   gtk_entry_set_text (GTK_ENTRY(entry02),"1");
   text02=gtk_entry_get_text (GTK_ENTRY (entry02));

   g_signal_connect(button01,"clicked",G_CALLBACK (input_value), NULL);
   gtk_box_pack_start(GTK_BOX(bbox01),button01,0,0,0);

   view = gtk_text_view_new_with_buffer ((GtkTextBuffer *) buffer01);

   gtk_box_pack_start (GTK_BOX (box), view, 1, 1, 0);

   buffer_entry =  gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));
   gtk_text_buffer_set_text (buffer_entry, "\n\n\n   choose sam sequence", -1);
   gtk_widget_show_all (window); }



