//   Copyright   Oliver Blechert   2021   //

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "main_win.h"
#include "load_reference_file.h"
#include "load_sam_file.h"
#include "analyse_sam_win_choose.h"
#include "analyse_sam_win_result.h"


extern char **reference_sequence;
extern char **sam_sequence;
extern int *sam_position;
extern int *sam_contig;
extern int sam_line;
char *text;
char *text_reference;

const char *text01;

extern int chromosome;
extern int position;


char *text_todisplay() {

   int sequence_displaycontig; sequence_displaycontig=chromosome;
   int sequence_displaystart; sequence_displaystart=position; 
   int sequence_displaylength; sequence_displaylength=1000; 
   int count_matches; count_matches=0; 
   int i;
   int i1;
   int i2;
   int is_tab;
   for (i=0;i<sam_line;i++){
      if (strlen(*(sam_sequence+i))>150 && sequence_displaystart<*(sam_position+i) && *(sam_position+i)<sequence_displaystart+(sequence_displaylength-150) && *(sam_contig+i)==sequence_displaycontig) {
         ++count_matches; } }
   text=malloc (sequence_displaylength*(count_matches+1)*sizeof (char));
   text_reference=malloc (sequence_displaylength*sizeof (char));
   count_matches=0; 
   i2=0;
   for (i=0;i<sequence_displaylength;i++) {
      text_reference[i2]=reference_sequence[sequence_displaycontig-1][i+position]; 
      text[i2]=reference_sequence[sequence_displaycontig-1][i+position]; 
      i2++; }
   text_reference[i2]='\0';
   text[i2]='\n';
   i2++; 
   for (i=0;i<sam_line;i++){
      if (strlen(*(sam_sequence+i))>150 && sequence_displaystart<*(sam_position+i) && *(sam_position+i)<sequence_displaystart+(sequence_displaylength-150) && *(sam_contig+i)==sequence_displaycontig) {
is_tab=0;
         for (i1=0;i1<*(sam_position+i-position)-1;i1++){
            text[i2]=' ';
            i2++; }
         for (i1=0;i1<150;i1++){
if (is_tab==0)
            text[i2]=sam_sequence[i][i1];
if (sam_sequence[i][i1]=='\t')is_tab=1;
            i2++; }
        text[i2]='\n';
        i2++; } }
return text; }

extern void samalign_win (GtkWidget *widget, gpointer data) {

   GtkWidget *window;
   GtkWidget *box;
   GtkWidget *menubar;
   GtkWidget *filemenu;
   GtkWidget *file;

   GtkWidget *quit;
   GtkWidget *helpabout;
   GtkWidget *helpmenu;
   GtkWidget *help;
   GtkWidget *about;

   GtkEntryBuffer *buffer;
   GtkWidget *entry;

   GtkWidget *sw;
   GtkTextIter start, end;
   GtkTextTag *tag;
   GtkWidget *view;
   GtkWidget *view01;
   GtkTextBuffer *buffer_entry;
   GtkWidget *frame01;
   GtkWidget *frame02;
   GtkWidget *bbox;

   window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW (window), "YNGS");
   gtk_window_set_default_size (GTK_WINDOW (window), 800, 300);

  
   menubar = gtk_menu_bar_new();
   filemenu = gtk_menu_new();
   file = gtk_menu_item_new_with_label("File");
   quit = gtk_menu_item_new_with_label("Quit");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(file), filemenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(filemenu), quit);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), file);

   g_signal_connect_swapped (quit, "activate", G_CALLBACK (gtk_widget_destroy), window);

   helpmenu = gtk_menu_new();
   helpabout = gtk_menu_item_new_with_label("Help");
   help = gtk_menu_item_new_with_label("Help");
   about = gtk_menu_item_new_with_label("About");
   gtk_menu_item_set_submenu(GTK_MENU_ITEM(helpabout), helpmenu);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), help);
   gtk_menu_shell_append(GTK_MENU_SHELL(helpmenu), about);
   gtk_menu_shell_append(GTK_MENU_SHELL(menubar), helpabout);

   box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 5);
   gtk_container_add (GTK_CONTAINER (window), box);
   gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, FALSE, 3);

   frame01 = gtk_frame_new ("Input");
   frame02 = gtk_frame_new ("Input");

   gtk_container_add (GTK_CONTAINER (box), frame01);
   gtk_container_add (GTK_CONTAINER (box), frame02);

   sw = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw), GTK_SHADOW_ETCHED_IN);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   view = gtk_text_view_new_with_buffer ((GtkTextBuffer *) buffer_entry);
   gtk_box_pack_start (GTK_BOX (box), sw, TRUE, TRUE, 0);
   gtk_container_add (GTK_CONTAINER (sw), view);

   buffer_entry =  gtk_text_view_get_buffer (GTK_TEXT_VIEW (view));
   gtk_text_buffer_set_text (buffer_entry, text_reference, -1);
   tag=gtk_text_buffer_create_tag (buffer_entry, "Monospace", "family", "Monospace", NULL); 
   gtk_text_buffer_get_iter_at_offset (buffer_entry, &start, 0);
   gtk_text_buffer_get_iter_at_offset (buffer_entry, &end, -1);
   gtk_text_buffer_apply_tag (buffer_entry, tag, &start, &end); 


   sw = gtk_scrolled_window_new (NULL, NULL);
   gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (sw), GTK_SHADOW_ETCHED_IN);
   gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (sw), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
   view01 = gtk_text_view_new_with_buffer ((GtkTextBuffer *) buffer);
   gtk_box_pack_start (GTK_BOX (box), sw, TRUE, TRUE, 0);

   gtk_container_add (GTK_CONTAINER (sw), view01);

   buffer =  gtk_text_view_get_buffer (GTK_TEXT_VIEW (view01));
   gtk_text_buffer_set_text (buffer, text, -1);
   tag=gtk_text_buffer_create_tag (buffer, "Monospace", "family", "Monospace", NULL); 
   gtk_text_buffer_get_iter_at_offset (buffer, &start, 0);
   gtk_text_buffer_get_iter_at_offset (buffer, &end, -1);
   gtk_text_buffer_apply_tag (buffer, tag, &start, &end); 

   gtk_widget_show_all (window); }


extern void sam_win_result () {
   text_todisplay();
   samalign_win (NULL,NULL); }



