//   Copyright   Oliver Blechert   2021   //

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "main_win.h"

#include "load_reference_file.h" 
#include "load_fastq_file.h" 
#include "load_sam_file.h"

#include "analyse_walking_win_choose.h"
#include "analyse_sam_win_choose.h"

extern int load_reference_file();
extern int load_fastq_file();
extern int load_sam_file();

extern void analyse_walking_win_choose (GtkWidget *widget, gpointer data);
extern void samchoosed_win (GtkWidget *widget, gpointer data);


extern void main_win (GtkApplication* win) {

   GtkWidget *window;

   GtkWidget *box; 
   GtkWidget *text_view;
   GtkTextBuffer *main_buffer;

   GtkWidget *menubar;
      GtkWidget *menu_main_gtk;
      GtkWidget *menu_main;
         GtkWidget *menu_main_quit;
      GtkWidget *menu_file_gtk;
      GtkWidget *menu_file;
         GtkWidget *menu_file_load_reference;
         GtkWidget *menu_file_load_fastq;
         GtkWidget *menu_file_load_sam;
      GtkWidget *menu_analyse;
      GtkWidget *menu_analyse_gtk;
         GtkWidget *menu_analyse_sam;
         GtkWidget *menu_analyse_fastq;
      GtkWidget *menu_help;
      GtkWidget *menu_help_gtk;
         GtkWidget *menu_help_help;
         GtkWidget *menu_help_about;

   window = gtk_application_window_new (win);
   gtk_window_set_title (GTK_WINDOW (window), "YNGS");
   gtk_window_set_default_size (GTK_WINDOW (window), 300, 300);

   menubar = gtk_menu_bar_new(); 
      menu_main_gtk = gtk_menu_new();
      menu_main = gtk_menu_item_new_with_label("Main");
         menu_main_quit = gtk_menu_item_new_with_label("Quit");
      menu_file_gtk = gtk_menu_new();
      menu_file = gtk_menu_item_new_with_label("File");
         menu_file_load_reference = gtk_menu_item_new_with_label("Load Reference");
         menu_file_load_fastq = gtk_menu_item_new_with_label("Load Fastq");
         menu_file_load_sam = gtk_menu_item_new_with_label("Load Sam");
      menu_analyse_gtk = gtk_menu_new();
      menu_analyse = gtk_menu_item_new_with_label("Analyse");
         menu_analyse_fastq = gtk_menu_item_new_with_label("Fastq");
         menu_analyse_sam = gtk_menu_item_new_with_label("Sam");
      menu_help_gtk = gtk_menu_new();
      menu_help = gtk_menu_item_new_with_label("Help");
         menu_help_help = gtk_menu_item_new_with_label("Help");
         menu_help_about = gtk_menu_item_new_with_label("About");


      gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_main), menu_main_gtk);
         gtk_menu_shell_append(GTK_MENU_SHELL(menu_main_gtk), menu_main_quit);
         gtk_menu_shell_append(GTK_MENU_SHELL(menubar), menu_main);

      gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_file), menu_file_gtk);
         gtk_menu_shell_append(GTK_MENU_SHELL(menu_file_gtk), menu_file_load_reference);
         gtk_menu_shell_append(GTK_MENU_SHELL(menu_file_gtk), menu_file_load_fastq);
         gtk_menu_shell_append(GTK_MENU_SHELL(menu_file_gtk), menu_file_load_sam);
         gtk_menu_shell_append(GTK_MENU_SHELL(menubar), menu_file);

      gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_analyse), menu_analyse_gtk);
         gtk_menu_shell_append(GTK_MENU_SHELL(menu_analyse_gtk), menu_analyse_fastq);
         gtk_menu_shell_append(GTK_MENU_SHELL(menu_analyse_gtk), menu_analyse_sam);
         gtk_menu_shell_append(GTK_MENU_SHELL(menubar), menu_analyse);

      gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_help), menu_help_gtk);
         gtk_menu_shell_append(GTK_MENU_SHELL(menu_help_gtk), menu_help_help);
         gtk_menu_shell_append(GTK_MENU_SHELL(menu_help_gtk), menu_help_about);
         gtk_menu_shell_append(GTK_MENU_SHELL(menubar), menu_help);

      g_signal_connect_swapped (menu_main_quit, "activate", G_CALLBACK (gtk_widget_destroy), window);
      g_signal_connect (menu_file_load_reference, "activate", G_CALLBACK (load_reference_file), NULL);
      g_signal_connect (menu_file_load_fastq, "activate", G_CALLBACK (load_fastq_file), NULL);
      g_signal_connect (menu_file_load_sam, "activate", G_CALLBACK (load_sam_file), NULL);

 g_signal_connect (menu_analyse_fastq, "activate", G_CALLBACK (analyse_walking_win_choose), NULL);
 g_signal_connect (menu_analyse_sam, "activate", G_CALLBACK (samchoosed_win), NULL);

   box = gtk_box_new(GTK_ORIENTATION_VERTICAL, 5);
   gtk_box_pack_start(GTK_BOX(box), menubar, FALSE, FALSE, 3);
   gtk_container_add(GTK_CONTAINER(window), box);
   text_view = gtk_text_view_new ();

   gtk_box_pack_start (GTK_BOX (box), text_view, 1, 1, 0);
   main_buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text_view));
   gtk_text_buffer_set_text (main_buffer, "\n\n\n      genome viewer\n\n\n      main window", -1);

   gtk_widget_show_all (window); }



