package edu.hust.go.example;

import java.io.File;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.text.DecimalFormat;
import java.util.*;
import edu.hust.go.gui.*;

import edu.hust.go.gui.OpenPageDialog;
import edu.hust.go.model.*;
import edu.hust.go.model.GoParser.OntologyDefineType;
import edu.hust.go.term.GO_term;
import edu.hust.go.term.Constants;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

/**
 * <p>
 * Title: GO4J
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2005
 * </p>
 * <p>
 * Company:
 * </p>
 * 
 * @author GQ Zhang
 * @version 1.0
 */

public class GUIExample extends JFrame implements ActionListener {
	String idPatternStr = Constants.geneOntologyIdPatternStr;

	String idPrefixStr = Constants.geneOntologyPrefix;

	String connectStr = Constants.geneOntologyOboConnector;

	DecimalFormat df = new DecimalFormat("0000000");

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	HashMap<String, GO_term> goMap;

	GraphCreator graphCreator;

	public Connection conn;

	JPanel panel;

	JLabel statusBar = new JLabel();

	JButton goDbButton = new JButton("Load GO Database");

	JButton goAnnoButton = new JButton("Annonation Database config");

	JButton queryGoButton = new JButton("Query");

	JButton queryGeneButton = new JButton("Query");

	JTextField mIdTextField = new JTextField("4519 4522");

	JTextField mGeneTextField = new JTextField("P21549 Q9BYV1");

	JCheckBox queryGeneBox = new JCheckBox("Retrive related genes");

	private JFileChooser jfc;

	private OpenPageDialog pageDialog;

	JPanel loadDbPanel = new JPanel();

	JScrollPane viewPanel = new JScrollPane();

	JTextPane textPanel = new JTextPane();

	String[] viewType = { "Tree Graph", "Tree", "Graph" };

	JComboBox viewTypeComboBox = new JComboBox(viewType);

	final String[] chindLevel = { "-1", "0", "1", "2", "3", "4" };

	final String[] goDefinitionType = { OntologyDefineType.OBO.name(), OntologyDefineType.OBOXML.name(), OntologyDefineType.RDFXML.name(), OntologyDefineType.OWL.name()};

	final String[] semanticType = { "CAO", "JIANG", "LIN", "RESNIK", "ZZL" };

	JComboBox childLevleComboBox = new JComboBox(chindLevel);

	JComboBox goDefTypeComboBox = new JComboBox(goDefinitionType);

	JComboBox semanComboBox = new JComboBox(semanticType);

	GridBagLayout gridBagLayout1 = new GridBagLayout();

	// Construct the application
	public GUIExample() {
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		try {
			jbInit();
		} catch (Exception e) {
			e.printStackTrace();
		}

		setVisible(true);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	// Main method
	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}
		new GUIExample();
	}

	private void jbInit() throws Exception {
		panel = (JPanel) this.getContentPane();
		panel.setLayout(new BorderLayout());
		this.setSize(new Dimension(600, 800));
		this.setTitle("Gene Ontology in Java");
		statusBar.setText("No GO definition file");
		panel.setMinimumSize(new Dimension(400, 300));

		goDbButton.addActionListener(this);
		goAnnoButton.addActionListener(this);
		goDbButton.setActionCommand("OBO parser");
		mIdTextField.setMinimumSize(new Dimension(100, 21));
		mIdTextField.setPreferredSize(new Dimension(250, 22));
		queryGoButton.addActionListener(this);
		queryGeneButton.addActionListener(this);
		JScrollPane messagePanel = new JScrollPane(textPanel);
		JSplitPane jSplitPane1 = new JSplitPane(JSplitPane.VERTICAL_SPLIT, viewPanel, messagePanel);
		jSplitPane1.setDividerLocation(500);
		panel.add(loadDbPanel, BorderLayout.NORTH);
		panel.add(jSplitPane1, BorderLayout.CENTER);
		panel.add(statusBar, BorderLayout.SOUTH);
		loadDbPanel.setMinimumSize(new Dimension(774, 100));
		loadDbPanel.setLayout(gridBagLayout1);

		GridBagConstraints c = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, GridBagConstraints.CENTER,
				GridBagConstraints.HORIZONTAL, new Insets(1, 1, 1, 1), 0, 0);
		loadDbPanel.add(goDbButton, c);
		c.gridwidth = 1;
		c.gridx = 2;
		loadDbPanel.add(goDefTypeComboBox, c);
		c.gridwidth = 2;
		c.gridx = 4;
		loadDbPanel.add(goAnnoButton, c);
		c.gridx = 0;
		c.gridy = 1;
		c.gridwidth = 1;
		loadDbPanel.add(new JLabel("View Type"), c);
		c.gridx = 1;
		loadDbPanel.add(viewTypeComboBox, c);
		c.gridx = 2;
		loadDbPanel.add(new JLabel("Child Depth"), c);
		c.gridx = 3;
		loadDbPanel.add(childLevleComboBox, c);
		c.gridx = 4;
		loadDbPanel.add(new JLabel("Semantic Method"), c);
		c.gridx = 5;
		loadDbPanel.add(semanComboBox, c);
		c.gridx = 0;
		c.gridy = 2;
		loadDbPanel.add(new JLabel("Query GO id"), c);
		c.gridx = 1;
		c.gridwidth = 3;
		loadDbPanel.add(mIdTextField, c);
		c.gridx = 4;
		c.gridwidth = 1;
		loadDbPanel.add(queryGoButton, c);
		c.gridx = 5;
		loadDbPanel.add(queryGeneBox, c);
		c.gridx = 0;
		c.gridy = 3;
		loadDbPanel.add(new JLabel("Query Gene Symble"), c);
		c.gridx = 1;
		c.gridwidth = 3;
		loadDbPanel.add(mGeneTextField, c);
		c.gridx = 4;
		c.gridwidth = 1;
		loadDbPanel.add(queryGeneButton, c);
		jfc = new JFileChooser();
		pageDialog = new OpenPageDialog(new Frame(), true);
		pageDialog.setFileChooser(jfc);
	}

	void queryGo(byte viewType, byte semanType, boolean withAnno) {
		String[] ids = parpareMultipleGoId(mIdTextField.getText());
		if (ids == null) {
			String msg = "Invalid Query Items\nPlaese separate items by space or comma\n :)";
			JOptionPane.showMessageDialog(this, msg);
			return;
		}
		if (graphCreator == null) {
			graphCreator = new GraphCreator(goMap);
		}
		int childLevel = Integer.parseInt((String) childLevleComboBox.getSelectedItem());
		Object[] objs = graphCreator.query(ids, viewType, semanType, childLevel);
		JComponent component = (JComponent) objs[0];
		String log = (String) objs[1];
		StringBuffer buf = new StringBuffer(log + "\n");
		if (withAnno) {
			Hashtable[] tables = queryAnnoRecords(ids, true);
			for (int i = 0; i < tables.length; i++) {
				Object[] keys = tables[i].keySet().toArray();
				Arrays.sort(keys);
				buf.append(">" + ids[i] + "\n");
				for (int j = 0; j < keys.length; j++) {
					buf.append(keys[j] + "\n");
					HashSet set = (HashSet) tables[i].get(keys[j]);
					for (Iterator iter = set.iterator(); iter.hasNext();) {
						buf.append("\t" + iter.next());
					}
					buf.append("\n");
				}
			}
		}
		viewPanel.setViewportView(component);
		textPanel.setText(buf.toString());
	}

	void queryAnno(byte viewType, byte semanType) {
		String[] ids = mGeneTextField.getText().trim().split(" +");
		if (graphCreator == null) {
			graphCreator = new GraphCreator(goMap);
		}
		int childLevel = Integer.parseInt((String) childLevleComboBox.getSelectedItem());
		Hashtable<String, HashSet<String>>[] tables = queryAnnoRecords(ids, false);
		HashSet<String> set = new HashSet<String>();
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < tables.length; i++) {
			buf.append(">" + ids[i] + "\n");
			for (Iterator<HashSet<String>> valueIter = tables[i].values().iterator(); valueIter.hasNext();) {
				HashSet<String> value = valueIter.next();
				set.addAll(value);
				for (Iterator iter = value.iterator(); iter.hasNext();) {
					buf.append(iter.next() + "\t");
				}
			}
			buf.append("\n");
		}
		String[] goIds = new String[set.size()];
		int i = 0;
		for (Iterator iter = set.iterator(); iter.hasNext();) {
			goIds[i] = (String) iter.next();
			i++;
		}

		Object[] objs = graphCreator.query(goIds, viewType, semanType, childLevel);
		JComponent component = (JComponent) objs[0];
		String log = (String) objs[1];
		viewPanel.setViewportView(component);
		textPanel.setText(buf.toString() + "\n" + log);
	}

	String[] parpareMultipleGoId(String ids) {
		ArrayList<String> list = new ArrayList<String>();
		String[] idArray = ids.trim().split("[, ]+");
		for (int i = 0; i < idArray.length; i++) {
			if (idArray[i].indexOf(":") >= 0) {
				idArray[i] = idArray[i].substring(idArray[i].indexOf(":") + 1);
			} else if (idArray[i].indexOf("_") >= 0) {
				idArray[i] = idArray[i].substring(idArray[i].indexOf("_") + 1);
			}
			try {
				idArray[i] = df.format(Integer.parseInt(idArray[i].trim()));
				if (!list.contains(idArray[i])) {
					list.add(idArray[i]);
				}
			} catch (NumberFormatException ex) {
			}
		}
		if (list.size() == 0) {
			return null;
		}
		idArray = new String[list.size()];
		list.toArray(idArray);
		return idArray;
	}

	public void actionPerformed(ActionEvent e) {
		byte viewType = GraphCreator.JTREEGRAPHVIEW;
		byte semType = Similarity.CAO;
		String str = (String) viewTypeComboBox.getSelectedItem();
		if (str.equals("Tree Graph")) {
			viewType = GraphCreator.JTREEGRAPHVIEW;
		} else if (str.equals("Tree")) {
			viewType = GraphCreator.JTREEVIEW;
		} else if (str.equals("Graph")) {
			viewType = GraphCreator.JGRAPHVIEW;
		}
		str = (String) semanComboBox.getSelectedItem();
		if (str.equals("CAO")) {
			semType = Similarity.CAO;
		} else if (str.equals("JIANG")) {
			semType = Similarity.JIANG;
		} else if (str.equals("LIN")) {
			semType = Similarity.LIN;
		} else if (str.equals("RESNIK")) {
			semType = Similarity.RESNIK;
		} else if (str.equals("ZZL")) {
			semType = Similarity.ZZL;
		}

		if (e.getSource() == goDbButton) {
			jfc.setDialogTitle("Load Go definition file with " + e.getActionCommand());
			int status = jfc.showOpenDialog(this);
			OntologyDefineType ontologyType = getOntologyType();
			if (status == JFileChooser.APPROVE_OPTION) {
				File chosenFile = jfc.getSelectedFile();
				if (ontologyType.ordinal() < OntologyDefineType.UNKNOWN.ordinal()) {
					try {
						goMap = OntologyGraphModel.loadGoDefinition(chosenFile, idPatternStr, idPrefixStr, connectStr,
								ontologyType);
						statusBar.setText("Current GO definition file: " + chosenFile.getPath());
					} catch (GoException excep) {
						goMap = null;
						System.out.println(excep);
					}
				}
			}
		} else if (e.getSource() == goAnnoButton) {
			DbConfig conf = new DbConfig(this);
			conf.setVisible(true);
		} else if (e.getSource() == queryGoButton) {
			if (goMap == null) {
				JOptionPane.showMessageDialog(this, "Please load GO definitione file first\n :)");
				return;
			}
			if (queryGeneBox.isSelected() && conn == null) {
				JOptionPane.showMessageDialog(this, "Please configure GO annonation dababase first\n :)");
			} else {
				queryGo(viewType, semType, queryGeneBox.isSelected());
			}
		} else if (e.getSource() == this.queryGeneButton) {
			if (goMap == null) {
				JOptionPane.showMessageDialog(this, "Please load GO definitione file first\n :)");
				return;
			}
			if (conn == null) {
				JOptionPane.showMessageDialog(this, "Please configure GO annonation dababase first\n :)");
			} else {
				queryAnno(viewType, semType);
			}
		}
	}

	private OntologyDefineType getOntologyType() {
		String goDefType = (String) goDefTypeComboBox.getSelectedItem();
		OntologyDefineType ontologyType = OntologyDefineType.valueOf(goDefType);
		if(ontologyType.equals(OntologyDefineType.OBO))
			connectStr=Constants.geneOntologyOboConnector;
		else if(ontologyType.equals(OntologyDefineType.OWL))
			connectStr=Constants.geneOntologyOwlConnector;
		else if(ontologyType.equals(OntologyDefineType.OBOXML))
			connectStr=Constants.geneOntologyOboXmlConnector;
		else if(ontologyType.equals(OntologyDefineType.RDFXML))
			connectStr=Constants.geneOntologyRdfXmlConnector;
		return ontologyType;
	}

	Hashtable<String, HashSet<String>>[] queryAnnoRecords(String[] queryArray, boolean goid) {
		Hashtable<String, HashSet<String>>[] tables = new Hashtable[queryArray.length];
		for (int i = 0; i < queryArray.length; i++) {
			tables[i] = new Hashtable<String, HashSet<String>>();
			String queryStr = "select * from annonation where ";
			try {
				if (goid) {
					queryStr = queryStr + "go_id='" + queryArray[i] + "'";
					Statement stmt = conn.createStatement();
					ResultSet rs = stmt.executeQuery(queryStr);
					for (int j = 0; j < 100 && rs.next(); j++) {
						String db = rs.getString(1);
						String gene = rs.getString(2);
						HashSet<String> set = tables[i].get(db) == null ? new HashSet<String>() : tables[i].get(db);
						set.add(gene);
						tables[i].put(db, set);
					}
					rs.close();
					stmt.close();

				} else {
					queryStr = queryStr + "db_object_id='" + queryArray[i] + "'";
					Statement stmt = conn.createStatement();
					ResultSet rs = stmt.executeQuery(queryStr);
					for (int j = 0; j < 100 && rs.next(); j++) {
						String db = rs.getString(1);
						String gene = rs.getString(5);
						HashSet<String> set = tables[i].get(db) == null ? new HashSet<String>() : tables[i].get(db);
						set.add(gene);
						tables[i].put(db, set);
					}
					rs.close();
					stmt.close();
				}

			} catch (Exception e) {
				System.out.println(e);
			}
		}
		return tables;
	}
}
