package edu.hust.go.model;

import java.io.*;
import java.util.Vector;
import java.util.HashMap;

import edu.hust.go.term.GO_term;
import edu.hust.go.term.OBOGo_term;

public class OboGoParser extends GoParser {

	public OboGoParser(String idPatternStr, String idPrefixStr, String connectStr, File _target) {
		this(idPatternStr, idPrefixStr, connectStr,_target, GoParser.defaultThreadNumber, GoParser.defaultPoolSize);
	}

	public OboGoParser(String idPatternStr, String idPrefixStr, String connectStr, File _target, int _maxThreadNumber) {
		this(idPatternStr, idPrefixStr, connectStr,_target, _maxThreadNumber, GoParser.defaultPoolSize);
	}

	/**
	 * @param _target
	 *            GO definition file
	 * @param _termType
	 *            SIMPLE_TERM or COMPLETE_TERM
	 * @param _maxThreadNumber
	 *            thread number
	 * @param _maxPoolSize
	 *            GO term parse speed may slower than read thread, if the number of unparsed terms greater than
	 *            maxPoolSize, new term has to wait until old terms have been parsed.
	 */
	public OboGoParser(String idPatternStr, String idPrefixStr, String connectStr, File _target, int _maxThreadNumber,
			int _maxPoolSize) {
		super(_target, _maxThreadNumber, _maxPoolSize);
		parse(idPatternStr, idPrefixStr, connectStr, GoParser.OntologyDefineType.OBO);
	}

	public GO_term getGoTermById(int id) {
		return (OBOGo_term) termMap.get(id);
	}

	protected void parseTarget() {
		String line = null;
		try {
			BufferedReader reader = new BufferedReader(new FileReader(target));
			HashMap<String, Vector<String>> map = null;
			while ((line = reader.readLine()) != null) {
				if (line.equals("[Term]")) {
					map = new HashMap<String, Vector<String>>();
				} else if (line.length() == 0) {
					if (map != null) {
						addDataToPool(map);
					}
					map = null;
				} else if (map != null) {
					int index = line.indexOf(":");
					String key = line.substring(0, index).trim();
					String value = line.substring(index + 1).trim();
					Vector<String> vector = (map.get(key) == null) ? new Vector<String>() : map.get(key);
					vector.add(value);
					map.put(key, vector);
				}
			}
			if (map != null) {
				addDataToPool(map);
			}
			reader.close();
		} catch (IOException e) {
			System.out.println(e);
		}
	}
}
