package edu.hust.go.term;

/**
 * <p>Title: GO4J</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2005</p>
 * <p>Company: </p>
 * @author GQ Zhang
 * @version 1.0
 */

import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

public abstract class DefaultGO_term implements GO_term {
	String idPatternStr;

	String idPrefixStr;

	String connectStr;

	Pattern termIdPattern = null;

	Pattern termPattern = null;

	String NULL_STRING = "";

	String id;

	String name;

	String def;

	String namespace;

	Vector<String> is_a;

	Vector<String> part_of;

	public DefaultGO_term(String _idPatternStr, String _idPrefixStr, String _connectStr) {
		idPatternStr = _idPatternStr;
		idPrefixStr = _idPrefixStr;
		connectStr = _connectStr;
		termIdPattern = Pattern.compile(idPatternStr);
		termPattern = Pattern.compile(idPrefixStr + connectStr + idPatternStr);
	}

	public String getDef() {
		return def;
	}

	public String getId() {
		return id;
	}

	protected String setId(String id_withPrefix) {
		Matcher matcher = termIdPattern.matcher(id_withPrefix);
		if (matcher.find()) {
			return matcher.group();
		}
		return NULL_STRING;
	}

	protected Vector<String> setId(Vector<String> id_withPrefixVector) {
		Vector<String> vector = new Vector<String>();
		if (id_withPrefixVector == null)
			return vector;
		for (int i = 0; i < id_withPrefixVector.size(); i++) {
			String newId = setId(id_withPrefixVector.get(i));
			if (!newId.equals(NULL_STRING))
				vector.add(newId);
		}
		return vector;
	}

	public Vector<String> getIs_a() {
		return is_a;
	}

	public String getName() {
		return name;
	}

	public String getNamespace() {
		return namespace;
	}

	public Vector<String> getPart_of() {
		return part_of;
	}

	public String toString() {
		return idPrefixStr + connectStr + id;
	}

	public String getDetailInfo() {
		StringBuffer buf = new StringBuffer();
		buf.append(getId()).append(", ").append(getName());
		return buf.toString();
	}
}
