###--- >>> `Palettes' <<<----- Color Palettes

	## alias	 help(rainbow)
	## alias	 help(heat.colors)
	## alias	 help(terrain.colors)
	## alias	 help(topo.colors)
	## alias	 help(cm.colors)

##___ Examples ___:

# A Color Wheel
piechart(rep(1,12), col=rainbow(12))

##------ Some palettes ------------
ch.col <- c("rainbow(n, start=.7, end=.1)", "heat.colors(n)",
            "terrain.colors(n)", "topo.colors(n)", "cm.colors(n)")

n <- if(.Device == "postscript") 64 else 16
     # Since for screen, larger n may give color allocation problem
nt <- length(ch.col)
i <- 1:n; j <- n / nt; d <- j/6; dy <- 2*d
plot(i,i+d, type="n", yaxt="n", ylab="", main=paste("color palettes;  n=",n))
for (k in 1:nt) {
  rect(i-.5,(k-1)*j+ dy, i+.4,  k*j, col=eval(parse(text=ch.col[k])))
  text(2*j,  k * j +dy/4, ch.col[k])
}

## Keywords: 'color', 'dplot'.


