###--- >>> `strptime' <<<----- Date-time Conversion Functions to and from Character

	## alias	 help(format.POSIXct)
	## alias	 help(format.POSIXlt)
	## alias	 help(strftime)
	## alias	 help(strptime)
	## alias	 help(as.character.POSIXt)
	## alias	 help(ISOdatetime)
	## alias	 help(ISOdate)

##___ Examples ___:

## locale-specific version of date()
format(Sys.time(), "%a %b %d %X %Y")
## we would include the timezone as in
## format(Sys.time(), "%a %b %d %X %Y %Z")
## but this crashes some Linux systems

## read in date info in format `ddmmmyyyy'
## This will give NA(s) in some locales.
## lct <- Sys.getlocale("LC_TIME"); Sys.setlocale("LC_TIME", "C")
x <- c("1jan1960", "2jan1960", "31mar1960", "30jul1960")
z <- strptime(x, "%d%b%Y")
## Sys.setlocale("LC_TIME", lct)
z

## read in date/time info in format `m/d/y h:m:s'
dates <- c("02/27/92", "02/27/92", "01/14/92",
           "02/28/92", "02/01/92")
times <- c("23:03:20", "22:29:56", "01:03:30",
           "18:21:03", "16:56:26")
x <- paste(dates, times)
z <- strptime(x, "%m/%d/%y %H:%M:%S")
z

## Keywords: 'utilities', 'chron'.


