###--- >>> `cutree' <<<----- Cut a tree into groups of data

	## alias	 help(cutree)

##___ Examples ___:

require(mva)
data(USArrests)

hc <- hclust(dist(USArrests))

cutree(hc, k=1:5)#k = 1 is trivial
cutree(hc, h=250)

## Compare the 2 and 3 grouping:
g24 <- cutree(hc, k = c(2,4))
table(g24[,"2"], g24[,"4"])

  ct <- cutree(hc, h = c(0, hc$height[c(1,49)], 1000))
  stopifnot(ct[,"0"]== 1:50,
     unique(ct[,2]) == 1:49,
            ct[,3]  == ct[,4],
            ct[,4]  == 1)


## Keywords: 'multivariate', 'cluster'.


