###--- >>> `beavers' <<<----- Body Temperature Series of Two Beavers

	## alias	 help(beavers)
	## alias	 help(beaver1)
	## alias	 help(beaver2)

##___ Examples ___:

data(beavers)

(yl <- range(beaver1$temp, beaver2$temp))

beaver.plot <- function(bdat, ...) {
  nam <- deparse(substitute(bdat))  
  attach(bdat)
  # Hours since start of day:
  hours <- time %/% 100 + 24*(day - day[1]) + (time %% 100)/60
  plot (hours, temp, type = "l", ...,
        main = paste(nam, "body temperature"))
  abline(h = 37.5, col = "gray", lty = 2)
  is.act <- activ == 1
  points(hours[is.act], temp[is.act], col = 2, cex = .8)
}
op <- par(mfrow = c(2,1), mar = c(3,3,4,2), mgp = .9* 2:0)
 beaver.plot(beaver1, ylim = yl)
 beaver.plot(beaver2, ylim = yl)
par(op)

## Keywords: 'datasets'.


