#!/usr/bin/env perl
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#             Pathway.pm odyssey
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Pathway.pm,v 1.4 2001/09/08 14:18:45 s98982km Exp $

package G::Ecell::Pathway;

use SubOpt;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	     _find_bad_substance
	     _find_pathway_gap
);
$VERSION = '0.01';

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::
sub new{
    my $pkg = shift;
    my $filename = shift;
    my $option = shift;
    my $this;

    return $this;
}


#find_bad_substance ver.20010525-01
#scripting by Koya Mori(s98982km@sfc.keio.ac.jp)
#This program finds bad substance from e-cell rule files.
#(array substance_list)=&find_bad_substance(string whole.eri,  string Membrane_reaction.txt,   string Analyzed_reaction.txt,   boolean debug);
sub _find_bad_substance{
    my $filename2=shift;
    my $filename3=shift;
    my $filename1=shift;
    my @RuleFileLine;
    my @HiddenSubstrate;
    my @substrate;
    my @product;
    my @MembraneSubstrate;
    my %WholeProduct;
    my $ProductName;
    my %lhash;
    my @result;

    @HiddenSubstrate=('ACCOA','ADP','AKG','AMP','ATP','CO2','COA','GLN','GLU','NAD','NADH','NADP','NADPH','NH3','PI','PPI','PYR');

    open(SFILE, $filename1)|| die("ERROR: file does not exist\n"); 
    &msg::error("open data file $filename1\n");

    while(<SFILE>){
	@RuleFileLine=split /\t/;
	if($RuleFileLine[0]!~/Type/){
	    push(@substrate,$RuleFileLine[5]) if($RuleFileLine[5]);
	    push(@product,$RuleFileLine[8]) if($RuleFileLine[8]);
	}
    }
    close(SFILE);


    open(SFILE, $filename3)|| die("ERROR: file does not exist\n"); 
    &msg::error("open data file $filename3\n");

    while(<SFILE>){
	@RuleFileLine=split /\t/;
	if($RuleFileLine[0]!~/Type/){
	    push(@MembraneSubstrate,$RuleFileLine[5]) if($RuleFileLine[5]);
	    push(@MembraneSubstrate,$RuleFileLine[8]) if($RuleFileLine[8]);
	}
    }
    close(SFILE); 
    

    open(WFILE, $filename2)|| die("ERROR: file does not exist\n"); 
    &msg::error("open data file $filename2\n");
    
    while(<WFILE>){
	@RuleFileLine=split /\t/;
	if($RuleFileLine[0] eq "REACTOR"){
	    foreach(@RuleFileLine){
		$ProductName=(split /:/)[-1] if(/Product/);
		$WholeProduct{substr($ProductName,0,-2)}=undef;
	    }
	}
    }
    close(WFILE);


    @lhash{@substrate}=undef;
    foreach(@product){
	delete $lhash{$_};
    }
    
    foreach(keys(%WholeProduct)){
	delete $lhash{$_};
    }

    foreach(@MembraneSubstrate){
	delete $lhash{$_};
    }


    @result=keys %lhash;
    return \@result;
}


#find_pathway_gap ver.20010528-01
#scripting by Koya Mori(s98982km@sfc.keio.ac.jp)
#This program finds pathway gap from e-cell rule files.
#(array substance_list)=&find_pathway_gap(string Analyzed_reaction.txt,   boolean debug);
sub _find_pathway_gap{
    my $filename=shift;
    my @RuleFileLine;
    my @HiddenSubstrate;
    my @substrate;
    my @product;
    my $ProductName;
    my %lhash;
    my @result;

    @HiddenSubstrate=('ACCOA','ADP','AKG','AMP','ATP','CO2','COA','GLN','GLU','NAD','NADH','NADP','NADPH','NH3','PI','PPI','PYR');


    open(SFILE, $filename)|| die("ERROR: file does not exist\n"); 
#    print STDERR ("open data file $filename\n");

    while(<SFILE>){
	@RuleFileLine=split /\t/;
	if($RuleFileLine[0]!~/Type/){
	    push(@substrate,$RuleFileLine[5]) if($RuleFileLine[5]);
	    push(@product,$RuleFileLine[8]) if($RuleFileLine[8]);
	}
    }
    close(SFILE);


    @lhash{@substrate}=undef;
    foreach(@product){
	delete $lhash{$_};
    }
    
    foreach(@HiddenSubstrate){
	delete $lhash{$_};
    }


    @result=keys %lhash;
    return \@result;
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Ecell::Pathway - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Ecell::Pathway;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Ecell::Pathway was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
