#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#   G::Messenger.pm G-language System Message Interface
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Messenger.pm,v 1.4 2001/09/20 07:15:15 s98982km Exp $
#
# G-language System is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language System is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language System -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@g-language.org> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package msg;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     interface
	     ask_interface
	     send
	     error
	     system_console
	     percent
	     progress
	     term_console
);
$VERSION = '0.01';

#::::::::::::::::::::::::::::::
#          Variables
#::::::::::::::::::::::::::::::

my %data;

$data{"interface"} = 'STDOUT';
my $console;
my $progress;
my $term;

#::::::::::::::::::::::::::::::
#           Methods
#::::::::::::::::::::::::::::::

sub term_console{
    $term = shift;
}

sub system_console{
    $console = shift;
}

sub progress{
    $progress = shift;
}

sub percent {
    my $percent = shift;
#    $progress->update($percent);
}

sub interface{
    $data{"interface"} = shift;
}

sub ask_interface{
    return $data{"interface"};
}

sub send{
    my @msg = @_;

    if ($data{"interface"} eq 'STDOUT'){
	print STDOUT @msg;
    }elsif ($data{"interface"} eq 'GUI'){
	$data{"term"} .= join('',@msg);
	$term->insert('','','',join('',@msg));
    }
}

sub error{
    my @msg = @_;

    if ($data{"interface"} eq 'STDOUT'){
	print STDERR @msg;
    }elsif ($data{"interface"} eq 'GUI'){
	$data{"system"} .= join('', @msg);
	$console->insert('','','',join('', @msg));
    }
}



1;
__END__


=head1 NAME

G::Messenger.pm G-language System Message Interface

=head1 SYNOPSIS

  use G::Messenger;

  &msg::to("GUI");
  &msg::in("Hello World!");


=head1 DESCRIPTION

  blah blah blah

=head1 AUTHOR

  Kazuharu Gaou Arakawa, gaou@g-language.org

=head1 SEE ALSO

perl(1).

=cut



