#!/usr/bin/env perl
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#             FreeEnergy.pm odyssey
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: FreeEnergy.pm,v 1.7 2001/10/08 16:46:36 t98901ka Exp $

package G::Seq::FreeEnergy;

use SubOpt;
use G::Tools::Graph;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	     RNAfold
	     foreach_RNAfold
);
$VERSION = '0.01';

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::
sub new{
    my $pkg = shift;
    my $filename = shift;
    my $option = shift;
    my $this;

    return $this;
}


#RNAfold 2001715
#Auther:Naoki Okubo
#This program executes RNAfold.
#usage:&RNAfold(pointer Genome,  int start_position,  int end_position);
sub RNAfold{
    &opt::default(output=>"stdout",filename=>'FreeEnergy.csv');
    my @args=opt::get(@_);

    my $seq=shift @args;
    my $start=shift @args;
    my $end=shift @args;
    my $filename=opt::val("filename");
    my $rna_fold_result;
    my $sq;
    my $num;
    my $result;

    $sq = substr($seq,$start,$end-$start);
    $rna_fold_result=qx!echo $sq | RNAfold!;
    $num++;
    $result=(split(/\s\(\s/,$rna_fold_result))[1];
    $result=~tr/\)\n//d;

    if(&opt::val("output") eq "stdout"){
	&msg::send($result,"\n");
    }
    if(&opt::val("output") eq "f"){
	open(FILE,">>$filename");
	print FILE $result,"\n";
	close(FILE);
    }
    
    mkdir("graph",0777);
    system('mv','rna.ps','graph/');

    return $result;
}


#RNAfold 2001715
#Auther:Naoki Okubo
#This program executes RNAfold.
#&RNAfoldG(pointer seq,  int start,  int end,  int  number,  boolean debug);
sub foreach_RNAfold{
    &opt::default(window=>50,output=>"show",filename=>"FreeEnergy.csv");
    my @args=opt::get(@_);
    
    my $seq=shift @args;
    my $start=shift @args;
    my $end=shift @args;
    my $number=opt::val("window");
    my $printer=opt::val("output");
    my $filename=opt::val("filename");
    my $i;
    my $cut;
    my $array;
    my $rna_fold_result;
    my $sq;
    my $num;
    my $x;
    my $y;
    my @y;
    my @RNA;


    if($printer=~/f/){
	open(FILE,">$filename");
    }

    $cut = substr($$seq,$start,$end-$start);


    for($i=0 ; $i<=length($cut)-$number ; $i=$i+1){
 
        $y=$i+$start;
        $sq = substr($$seq,$y,$number);


        $rna_fold_result=qx!echo $sq | RNAfold!;
        $num++;
        $rna_fold_result=~tr/()//d;
        $rna_fold_result=~tr/[A-Z]\n//d;
        $rna_fold_result=~s/\.\.//g;
        $rna_fold_result=~s/\.\ //g;
	$rna_fold_result=~tr/ //d;
	push(@RNA,$rna_fold_result);

	if($printer=~/f/){
	    print FILE $y,",",$y+$number,",",$rna_fold_result,"\n";
	}
	if($printer!~/[fn]/){
	    &msg::send($y,"..",$y+$number,"\t",$rna_fold_result,"\n");
 	}
	push(@y,$y);
    }
    
    unlink("rna.ps");

    if($printer=~/g/ || $printer=~/show/){
        &G::Tools::Graph::_UniUniGrapher(\@y,\@RNA,-filename=>"FreeEnergy.gif",-x=>"position",-y=>"free energy",-title=>"free energy");
    }

    system('gimv','graph/FreeEnergy.gif') if($printer=~/show/);

    return \@RNA;
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Seq::FreeEnergy - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Seq::FreeEnergy;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Seq::FreeEnergy was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
