#!/usr/bin/env perl
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#             OverLapping.pm odyssey
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: OverLapping.pm,v 1.3 2001/09/08 13:44:38 s98982km Exp $

package G::Seq::OverLapping;

use SubOpt;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	     over_lapping_finder
	     _over_lapping_printer
);
$VERSION = '0.01';

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::
sub new{
    my $pkg = shift;
    my $filename = shift;
    my $option = shift;
    my $this;

    return $this;
}


#over_lapping_finder ver.20010722-01
#scripting by Koya Mori(mory@g-language.org)
#This program finds over rapping gene.
#Options
#-output   "f" for file output. "stdout" for STD output.
#-filename output file name.
#&over_lapping_finder(pointer Genome,  boolean debug);
sub over_lapping_finder{
    &opt::default(output=>"stdout",filename=>"over_lapping.csv");
    my @args=opt::get(@_);
    
    my $gb=shift @args;
    my $output=opt::val("output");
    my $filename=opt::val("filename");
    my $num=1;
    my $tmp;
    my $start;
    my $end;
    my %result;
    my $q;
    my $over;
    my $switch;
    my $type;

    foreach($gb->cds()){
	$over=0;
	$switch=0;
	$tmp=$num-1;
	if($gb->{"CDS$num"}->{start} > $gb->{"CDS$tmp"}->{start} && $gb->{"CDS$num"}->{end} < $gb->{"CDS$tmp"}->{end}){
	    $switch=1;
	    $over=-($gb->{"CDS$num"}->{end}-$gb->{"CDS$num"}->{start}+1);
	    $type="internal";
	}
	elsif($gb->{"CDS$num"}->{direction} eq 'direct' && $gb->{"CDS"."$tmp"}->{direction} eq 'direct'){
	    $start = $gb->{"CDS$num"}->{start};
	    $end = $gb->{"CDS"."$tmp"}->{end};
	    if($start-$end-1<0){
		$switch=1;
		$over=$start-$end-1;
		$type="uni-directional";
	    } 
	}
	elsif($gb->{"CDS$num"}->{direction} eq 'complement' && $gb->{"CDS"."$tmp"}->{direction} eq 'complement'){
	    $start = $gb->{"CDS$num"}->{start};
	    $end = $gb->{"CDS"."$tmp"}->{end};
	    if($start-$end-1<0){
		$switch=1;
		$over=$start-$end-1;
		$type="uni-directional";
	    }
	}
	elsif($gb->{"CDS$num"}->{direction} eq 'direct' && $gb->{"CDS"."$tmp"}->{direction} eq 'complement'){
	    $start = $gb->{"CDS$num"}->{start};
	    $end = $gb->{"CDS"."$tmp"}->{end};
	    if($start-$end-1<0){
		$switch=1;
		$over=$start-$end-1;      
		$type="head-on";
	    }
	}    
	elsif($gb->{"CDS$num"}->{direction} eq 'complement' && $gb->{"CDS"."$tmp"}->{direction} eq 'direct'){
	    $start = $gb->{"CDS$num"}->{start};
	    $end = $gb->{"CDS"."$tmp"}->{end};
	    if($start-$end-1<0){
		$switch=1;
		$over=$start-$end-1;
		$type="end-on";
	    }
	}    
	if($switch==1){
	    $result{$q}{before}="CDS$tmp";
	    $result{$q}{after}="CDS$num";
	    $result{$q}{BeforeStart}=$gb->{"CDS$tmp"}->{start};
	    $result{$q}{BeforeEnd}=$gb->{"CDS$tmp"}->{end};
	    $result{$q}{AfterStart}=$gb->{"CDS$num"}->{start};
	    $result{$q}{AfterEnd}=$gb->{"CDS$num"}->{end};
	    $result{$q}{BeforeDirect}=$gb->{"CDS$tmp"}->{direction};
	    $result{$q}{AfterDirect}=$gb->{"CDS$num"}->{direction};
	    $result{$q}{OverLap}=$over;
	    $result{$q}{type}=$type;
	    $q++;
	}
	$num++;
    }

    if($output eq "f"){
	_over_lapping_printer(\%result,-output=>$output,-filename=>$filename);
    }
    if($output eq "stdout"){
	_over_lapping_printer(\%result,-output=>"stdout");
    }
    return \%result;
}


#over_lapping_printer ver.20010722-01
#scripting by Koya Mori(mory@g-language.org)
#This program prints result of over_lapping_finder.pl.
#&over_lapping_finder(pointer over_lapping_finder,  boolean debug);
sub _over_lapping_printer{
    &opt::default(output=>"stdout",filename=>"over_lapping.csv");
    my @args=opt::get(@_);

    my $result=shift @args;
    my $printer=opt::val("output");
    my $filename=opt::val("filename");
    my $debug=shift;

    
    if($printer eq "f"){
	open(FILE,">$filename");
	foreach(sort{$a <=> $b} keys(%$result)){
	    print FILE "$$result{$_}{before},$$result{$_}{after},$$result{$_}{BeforeStart},$$result{$_}{BeforeEnd},$$result{$_}{AfterStart},$$result{$_}{AfterEnd},$$result{$_}{OverLap},$$result{$_}{type},$$result{$_}{BeforeDirect},$$result{$_}{AfterDirect}\n";
	}   
	print FILE "\n\n";
	close(FILE);
    }
    else{
	foreach(sort{$a <=> $b} keys(%$result)){
	    &msg::send("$$result{$_}{before}\t$$result{$_}{after}\t$$result{$_}{BeforeStart}..$$result{$_}{BeforeEnd}\t$$result{$_}{AfterStart}..$$result{$_}{AfterEnd}\t$$result{$_}{OverLap}\t$$result{$_}{type}\t$$result{$_}{BeforeDirect}\t$$result{$_}{AfterDirect}\n");
	}
    }
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Seq::OverLapping - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Seq::OverLapping;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Seq::OverLapping was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
