#!/usr/bin/env perl

##################################################
#  Bacteria Analysis System Core                 #
##################################################
#   $Id: BAS.pm,v 1.20 2001/09/16 02:18:47 s98982km Exp $
#Generated by G-language System.
#This is a core system of Bacteria Analysis System.
#usage:&BAS_run(string  gcf-file);

package G::System::BAS;

use G;
use SubOpt;
use strict('vars');
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	BAS_run
);
$VERSION = '0.01';


#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::

my %cf;
my %ref;
my $GCF_name;

sub new{
    my $pkg = shift;
    my $filename = shift;
    my $option = shift;
    my $this;

    return $this;
}
 
sub BAS_run{
    &opt::default(-src=>"");
    my @args=opt::get(@_); 

    my $gcfname=shift @args;
    my $file=opt::val("src");
    open(FILE,">$file") if($file);

    unless(lstat "$gcfname"){
        &msg::error("BAS: No such file or directory\n");
        return "HOGE";
    }

    require("$gcfname");

    my %dir;
    my @line;
    my @sub;
    my @tmp;
    my @option;
    my $i;
    my $p;
    my $q;
    my $r;
    my $method;
    my $instance;
    my $output;
    my $options;
    my $ref;
    my $ref_str;
    my @CONF;

#####################################
#  Reading Configuratin file        #
#####################################

open(GCF, $gcfname);
while(<GCF>){
	if(/CONF/){
	    while(<GCF>){
		s/\n//g;
		last if (/^CONF/);
		push (@CONF, $_);
	    }
	}
}
foreach(@CONF){
#foreach(split(/\n/,G::System::BAS_conf::BAS())){
    next if($_=~/^\#/ || $_=~/^\s/);
    if($_=~/^(\S+)\s+<\s+(.*)/){
	$cf{G}{"$1"}=$2;
	next;
    }
    if($_=~/^\$name:(.*)\$/){
	$GCF_name=$1;
	$GCF_name=~tr/ *//d;
	next;
    }
    if($_=~/([^\#]*)\&(.*)\((.*)\)\;\s+\@(\d*)/){
	$cf{$2}{exe}="U";
	$p=1;
	$r=1;
	foreach(split(/,/,$3)){
	    if(substr($_,0,1) eq '$'){
		$_=~tr/\$//d;
		$cf{$2}{"$p"."ref"}=$_;
		$p++;
	    }
	    else{
		$cf{$2}{"$r"."param"}=$_;
		$r++;
	    }
	}
        if($4 eq ''){
            push(@tmp,$2);
        }
        else{
	    if($sub[$4] ne ''){
	        &msg::error("$2: invalid turns!\n");
                return "HOGE";
	    }
	    else{
	        $sub[$4]=$2;
	    }
        }
	$cf{$2}{coment}=$2;
	my $tmp1=$1;
	my $tmp2=$2;
	if($tmp1=~/\$/ && $tmp1=~/\=/){
	    $tmp1=~tr/\=\$//d;
	    $cf{$tmp2}{return}=$tmp1;
	}
        next;
    }
    @line=split /\s+/;
    if($line[0]=~/\>/){
	$method=substr($line[0],1);
	$cf{$method}{exe}=$line[1];
	$i=1;
	$q=1;
	if($_=~/^\>.*\s*Y\s*\@(\d*)/){
            if($1 eq ''){
                push(@tmp,$method);
            }
            else{
	        if($sub[$1] ne ''){
		    &msg::error("$method: invalid turns!\n");
		    return "HOGE";
	        }
	        else{
		    $sub[$1]=$method;
	        }
            }
	}
    }
    elsif($line[0]=~/^\%/){
	$_=~tr/\%//d;
	$cf{$method}{coment}=$_;
    }
    elsif($line[0] eq "-Return"){
	unless($#line==0 || $line[1]=~/^\#/){
	    $cf{$method}{return}=$line[1];
	}
    }
    elsif($line[0]=~/^-/){
	unless($#line==0 || $line[1]=~/^\#/){
	    $cf{$method}{$line[0]}=$line[1];
	}
    }
    elsif($line[0]=~/^ref_/){
	if($#line==0 && $cf{$method}{exe} eq "Y"){
	    &msg::error("$method: Lacking paramerter input!\n");
	    return "HOGE";
	}
	elsif($line[1]=~/^\#/ && $cf{$method}{exe} eq "Y"){
	    &msg::error("$method: Lacking paramerter input!\n");
	    return "HOGE";
	}
        else{
	    $cf{$method}{"$q"."ref"}=$line[1];
            $ref{$method}[$q-1]="ref";
	    $q++;
        }
    }
    elsif($line[0]=~/^instance_/){
	if($#line==0 && $cf{$method}{exe} eq "Y"){
	    &msg::error("$method: Lacking paramerter input!\n");
	    return "HOGE";
	}
	elsif($line[1]=~/^\#/ && $cf{$method}{exe} eq "Y"){
	    &msg::error("$method: Lacking paramerter input!\n");
	    return "HOGE";
	}
        else{
	    $cf{$method}{"$q"."ref"}=$line[1];
            $ref{$method}[$q-1]="instance";
	    $q++;
        }
    }
    else{
	if($#line==0 && $cf{$method}{exe} eq "Y"){
	    &msg::error("$method: Lacking paramerter input!\n");
	    return "HOGE";
	}
	elsif($line[1]=~/^\#/ && $cf{$method}{exe} eq "Y"){
	    &msg::error("$method: Lacking paramerter input!\n");
	    return "HOGE";
	}
	else{
	    $cf{$method}{"$i"."param"}=$line[1];
	    $i++;
	}
    }
}
push(@sub,@tmp);

if($file){
    &src(1,-header=>1);
    &src("require\(\"$gcfname\"\)\;\n");
}

#####################################
#  Making instance                  #
#####################################

foreach (keys(%{$cf{G}})){
    my $tmp=$_;
    if($file){
        &src("\$$tmp\=new G\(\"$cf{G}{$tmp}\"\)\;\n");
    }
    else{
        ${$tmp}=new G("$cf{G}{$tmp}");
    }
    $dir{$tmp}=(split('\.',(split('/',$cf{G}{$tmp}))[-1]))[0];
}

#####################################
#  Methods executing                #
#####################################

if($file){
    &src("mkdir\(\"$GCF_name\",0777\)\;\nchdir\(\"$GCF_name\"\)\;\n");
}
else{
    mkdir($GCF_name,0777);
    chdir($GCF_name);
}

my $subnum = 1;
my $suball = $#sub + 1;

foreach(@sub){
    &msg::percent($subnum/$suball);
    $subnum ++;
    next if($_ eq "G");
    @option=();
    if($cf{"$_"}{exe} eq "Y"){
	&msg::error("\#\n\#$cf{$_}{coment}\n\#\n") if($file eq '');
	($ref,$options)=&opt_manager("$_");
	if($#$ref==0){
	    if($$ref[0]=~/->/){
		($instance,$ref_str)=&ref_manager($$ref[0]);
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\\\$$instance\-\>\{$ref_str\}@option\)\;");
                }
                else{
		    ${$cf{$_}{return}}=&{$_}(\${$instance}->{"$ref_str"},@$options);
                }
	    }
       	    elsif($ref{$_}[0] eq "ref"){
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\\\$$$ref[0]@option\)\;");
                }
                else{
	            ${$cf{$_}{return}}=&{$_}(\${$$ref[0]},@$options);
                }
            }
	    elsif($ref{$_}[0] eq "instance"){
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\$$$ref[0]@option\)\;");
                }
                else{
		    ${$cf{$_}{return}}=&{$_}(${$$ref[0]},@$options);
                }
            }
        }
        elsif($#$ref==1){
	    if($ref{$_}[0] eq "instance" && $$ref[1]=~/->/){
		($instance,$ref_str)=&ref_manager($$ref[1]);
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\$$$ref[0]\,\\\$$instance\-\>\{$ref_str\}@option\)\;");
                }
                else{
		    ${$cf{$_}{return}}=&{$_}(${$$ref[0]},\${$instance}->{"$ref_str"},@$options);
                }
	    }
	    elsif($ref{$_}[0]=~/->/ && $$ref[1] eq "instance"){
		($instance,$ref_str)=&ref_manager($$ref[0]);
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\\\$$instance\-\>\{$ref_str\}\,\$$$ref[1]@option\)\;");
                }
                else{                
		    ${$cf{$_}{return}}=&{$_}(${$$ref[0]},\${$instance}->{"$ref_str"},@$options);
                }
	    }
	    elsif($ref{$_}[0] eq "ref" && $$ref[1]=~/->/){
		($instance,$ref_str)=&ref_manager($$ref[1]);
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\\\$$$ref[0]\,\\\$$instance\-\>\{$ref_str\}@option\)\;");
                }
                else{
		    ${$cf{$_}{return}}=&{$_}(\${$$ref[0]},\${$instance}->{"$ref_str"},@$options);
                }
	    }
	    elsif($$ref[0]=~/->/ && $ref{$_}[1] eq "ref"){
		($instance,$ref_str)=&ref_manager($$ref[0]);
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\\\$$instance\-\>\{$ref_str\}\,\\\$$$ref[1]@option\)\;");
                }
                else{
		    ${$cf{$_}{return}}=&{$_}(\${$instance}->{"$ref_str"},\${$$ref[1]},@$options);
                }
	    }
       	    elsif($ref{$_}[0] eq "instance" && $ref{$_}[1] eq "ref"){
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\$$$ref[0]\,\\\$$$ref[1]@option\)\;"); 
                }
                else{ 
	            ${$cf{$_}{return}}=&{$_}(${$$ref[0]},\${$$ref[1]},@$options);
                }
            }
      	    elsif($ref{$_}[0] eq "ref" && $ref{$_}[1] eq "instance"){
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\\\$$$ref[0]\,\$$$ref[1]@option\)\;"); 
                }
                else{
	            ${$cf{$_}{return}}=&{$_}(\${$$ref[1]},${$$ref[0]},@$options);
                }
            }
      	    elsif($ref{$_}[0] eq "ref" && $ref{$_}[1] eq "ref"){
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\\\$$$ref[0]\,\\\$$$ref[1]@option\)\;"); 
                }
                else{
	            ${$cf{$_}{return}}=&{$_}(\${$$ref[0]},\${$$ref[1]},@$options);
                }
            }
	    elsif($ref{$_}[0] eq "instance" && $ref{$_}[1] eq "instance"){
                if($file){
                    @option=(','.join(",",@$options)) if($#$options!=-1);
                    &src("\$$cf{$_}{return}\=\&$_\(\$$$ref[0]\,\$$$ref[1]@option\)\;"); 
                }
                else{
		    ${$cf{$_}{return}}=&{$_}(${$$ref[0]},${$$ref[1]},@$options);
                }
            }
        }
    }
    if($cf{"$_"}{exe} eq "U"){
	&msg::error("\#\n\#$cf{$_}{coment}\n\#\n") if($file eq '');
	($ref,$options)=&opt_manager("$_");
	if($#$ref==-1){
            if($file){
                &src("\$$cf{$_}{return}\=\&\G::System::BAS_conf::$_\(\)\;");
            }
            else{
	        ${$cf{$_}{return}}=&{$G::System::BAS_conf::{$_}}();
            }
        }
        if($#$ref==0){
            if($file){
                @option=(','.join(",",@$options)) if($#$options!=-1);
                &src("\$$cf{$_}{return}\=\&\G::System::BAS_conf::$_\(\$$$ref[0]@option\)\;");
            }
            else{
                ${$cf{$_}{return}}=&{$G::System::BAS_conf::{$_}}(${$$ref[0]},@$options);
            }
        }
        if($#$ref==1){
            if($file){
                @option=(','.join(",",@$options)) if($#$options!=-1);
                &src("\$$cf{$_}{return}\=\&\G::System::BAS_conf::$_\(\$$$ref[0],\$$$ref[1]@option\)\;");
            }
            else{
                ${$cf{$_}{return}}=&{$G::System::BAS_conf::{$_}}(${$$ref[0]},${$$ref[1]},@$options);
            }
        }
    }
}
close(FILE) if($file);
}

#####################################
#  Subroutines                      #
#####################################

sub opt_manager{
    my $method=shift;
    my @option;
    my @ref;

    foreach(sort{$b <=> $a} keys(%{$cf{$method}})){
	next if($_ eq "exe");
	next if($_ eq "coment");
	next if($_ eq "return");
	if($cf{$method}{$_} ne ""){
	    if(/ref/){
		unshift(@ref,$cf{$method}{$_});
	    }
	    elsif(/param/){
		my $tmp=$cf{$method}{$_};
		unshift(@option,$tmp);
	    }
	    else{
		push(@option,$_);
		push(@option,$cf{$method}{$_});
	    }
	}
    }
    return \@ref,\@option;
}


sub ref_manager{
    my $param=shift;
    my $instance;
    my $ref;

    if($param=~/->/){
	$instance=substr($param,0,index($param,'->'));
	$ref=substr($param,index($param,'->'));
	$ref=~tr/->\{\}//d;
    }
    
    return ($instance,$ref);
}


sub src{
    &opt::default(header=>'');
    my @args=opt::get(@_);

    my $line=shift @args;
    my $header=opt::val(header);
    
    if($header){
	print FILE <<'HEAD';
#!/usr/bin/env perl

##################################################
HEAD
		
        print FILE "\#  $GCF_name source script\n";
	print FILE <<'HEAD2'
##################################################
#Generated by G-language System.
#This program analyses bacterial Genomes.
#usage:perl This_file_name

use G;
HEAD2
    }
    else{
	if($line=~/^\$\w*\(\w*\)\=.*/){
	    $line=substr($line,index($line,'=')+1);
	} 
	elsif($line=~/^\$\s*\=.*/){
	    $line=substr($line,index($line,'=')+1);
	}
	print FILE $line,"\n";
    }
}

sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::System::BAS - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::System::BAS;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::System::BAS was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
