#!/usr/bin/env perl
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#             Blast.pm odyssey
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Blast.pm,v 1.5 2001/09/22 10:58:41 s98982km Exp $

package G::Tools::Blast;

use SubOpt;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	     _blast_tp_finder
	     _blaster
);
$VERSION = '0.01';

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::
sub new{
    my $pkg = shift;
    my $filename = shift;
    my $option = shift;
    my $this;

    return $this;
}


sub _blaster{  
    &opt::default(p=>'blastn',qr=>'off',input=>"file");
    my @args=opt::get(@_);

    my $qr=&opt::val("qr");
    my $input=&opt::val("input");
    my $seq;
    my @param;
    my %opt;

    $opt{d}=shift @args;
    if($input eq 'seq'){
	$seq=shift @args;
	open(FILE,'>/tmp/tmp.seq');
	print FILE '>sequence',"\n";
	print FILE $$seq,"\n";
	close(FILE);
	$opt{i}="/tmp/tmp.seq"; 
    }
    else{
	$opt{i}=shift @args;
    }

    $opt{p}=opt::val("p");
    $opt{e}=opt::val("e");
    $opt{m}=opt::val("m");
    $opt{o}=opt::val("o");
    $opt{F}=opt::val("F");
    $opt{G}=opt::val("G");
    $opt{E}=opt::val("E");
    $opt{X}=opt::val("X");
    $opt{I}=opt::val("I");
    $opt{q}=opt::val("q");
    $opt{r}=opt::val("r");
    $opt{v}=opt::val("v");
    $opt{b}=opt::val("b");
    $opt{f}=opt::val("f");
    $opt{g}=opt::val("g");
    $opt{Q}=opt::val("Q");
    $opt{D}=opt::val("D");
    $opt{a}=opt::val("a");
    $opt{J}=opt::val("J");
    $opt{M}=opt::val("M");
    $opt{W}=opt::val("W");
    $opt{z}=opt::val("z");
    $opt{K}=opt::val("K");
    $opt{P}=opt::val("P");
    $opt{Y}=opt::val("Y");
    $opt{S}=opt::val("S");
    $opt{T}=opt::val("T");
    $opt{U}=opt::val("U");
    $opt{y}=opt::val("y");
    $opt{Z}=opt::val("Z");
    $opt{n}=opt::val("n");
    $opt{A}=opt::val("A");
    $opt{w}=opt::val("w");
    $opt{t}=opt::val("t");
    $opt{L}=opt::val("L");
    $opt{O}=opt::val("O");
    $opt{l}=opt::val("l");
    $opt{R}=opt::val("R");

    foreach(sort keys(%opt)){
	next if($opt{$_} eq '');
	push(@param,'-'.$_);
	push(@param,$opt{$_});
    }


    system('blastall',@param) if($qr eq "off");
    system('qr','blastall',@param) if($qr eq "on");

    unlink('/tmp/tmp.seq') if($input eq 'seq');
    return join(' ',@param);
}


sub _blast_tp_finder{
    my $file=shift;
    my @id_query;
    my $query_name;
    my @query;
    my @query_num;
    my $s1;
    my @query_num_sort;
    my $query_start;
    my $query_end;
    my @sbject_num;
    my @sbject_num_sort;
    my $sbject_start;
    my $sbject_end;
    my $idname;
    my @strand;
    my @sbject;
    my @infile;
    my @score;
    my $evalue;
    
    
    &msg::send("\nEVALUE-->QUERY-->DATABASE-->QUERY RANGE-->DATABASE RANGE-->STRAND\n---------------------------------------------------------------------------\n");
    open(FILE,"$file");
    while(<FILE>){
	if(/Query=/){
	    @id_query=split(/\s/,$_);
	    $_=~s/Query= //;
	    $_=~tr/\n//d;
	    $query_name=$_;    
	}
	if(/Query:/){
	    @query=split(/[\s]+/,$_);
	    push(@query_num,$query[1]);
	    push(@query_num,$query[3]);
	    $s1=1;
	}
	if(/Score / || />/ || /Lambda/){
	    &msg::send("$evalue");
	    @score=split(/Expect/,$_);
	    $evalue=$score[1];
	    $evalue=~tr/=//d;
	    $evalue=~tr/\n//d;
	    @query_num_sort=sort {$b<=>$a} @query_num;
	    $query_start=pop @query_num_sort;
	    $query_end=shift @query_num_sort;
	    @sbject_num_sort=sort {$b<=>$a} @sbject_num;
	    $sbject_start=pop @sbject_num_sort;
	    $sbject_end=shift @sbject_num_sort;
	    if($query_start!=""){
		&msg::send("\t$query_name\t$query_start>>$query_end   \t$idname\t$sbject_start>>$sbject_end   \t$strand[5]\n");
	    }
	    @query=();
	    @query_num=();
	    @sbject=();
	    @sbject_num=();
	    $s1=0;
	    
	}
	if(/>/){
	    $idname=$_;
	    $idname=~tr/>//d;
	    $idname=~tr/\n//d;
	}
	if($s1==0){
	    if(/Strand/){
		@strand=split(/\s/,$_);
	    }
	}
	if($s1==1){
	    if(/Sbjct:/){
		@sbject=split(/\s+/,$_);
		push(@sbject_num,$sbject[1]);
		push(@sbject_num,$sbject[3]);
	    }
	}
    }
    close(FILE);
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::H2v - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::Blast;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::Blast was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
