#!/usr/bin/env perl
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#             Graph.pm odyssey
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Graph.pm,v 1.8 2001/09/09 04:57:25 t98901ka Exp $

package G::Tools::Graph;

use SubOpt;
use strict;
use Chart::Graph qw(gnuplot);
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	     _R_base_graph
	     _R_RNA_graph
	     _UniUniGrapher
	     _UniMultiGrapher
);
$VERSION = '0.01';

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::
sub new{
    my $pkg = shift;
    my $filename = shift;
    my $option = shift;
    my $this;

    return $this;
}


# _UniMultiGrapher ver.20010906-01
# Author: Kazuharu Gaou Arakawa
# Usage: &_UniMultiGrapher(ref y, ref x1, refx2, ...);
# Options:
# -x                  name of x axis (default: x)
# -y                  name of y axis (default: y)
# -x1, -x2, ..., x$i  title of graph x$i (default: x$i)
# -filename           outfile name   (default: graph.gif)
# -style              style of graph (default: lines)
# -type               type of data (default: columns)
# Description:
#   This method creates a two dimensional graph with gnuplot.
#   Multiple x references can be used.
#   Options follow that of Chart::Graph.
# Requirements
#   Chart::Graph qw(gnuplot)
#   SubOpt


sub _UniMultiGrapher {
    &opt::default(x=>"x", y=>"y", title=>"graph", 
		  filename=>"graph.gif", type=>"columns",
		  style=>"lines");

    mkdir ("graph", 0777);    
    my @args = opt::get(@_);
    my $ref_y = shift @args;
    my @command = ({"title" => opt::val("title"),
		    "output file" => 'graph/' . opt::val("filename"),
		    "x-axis label" => opt::val("x"),
		    "y-axis label" => opt::val("y")}, );
    my $i = 1;
    foreach my $ref_x (@args){
	my $title = opt::val("x$i");
	$title = "x$i" if ($title eq '');

	push (@command,
	      [{"title" => $title,
		"style" => opt::val("style"),
		"type" => opt::val("type")},
	       $ref_y, $ref_x, ]
	      );
	$i ++;
    }
    
    gnuplot(@command);
}


# UniUniGrapher ver.20010829-01
# Author: Kazuharu Gaou Arakawa
# Usage: &UniUniGrapher(ref array1, ref array2);
# Options:
# -x        name of x axis (default: x)
# -y        name of y axis (default: y)
# -title    title of graph (default: graph)
# -filename outfile name   (default: graph.gif)
# -style    style of graph (default: lines)
# -type     type of graph  (default: columns)
# Description:
#   This method creates a two dimensional graph with gnuplot.
#   Options follow that of Chart::Graph.
# Requirements
#   Chart::Graph qw(gnuplot)
#   SubOpt


sub _UniUniGrapher {
    &opt::default(x=>"x", y=>"y", title=>"graph", 
		 filename=>"graph.gif",
		 style=>"lines", type=>"columns");

    my @args = opt::get(@_);
    my $array_ref1 = shift;
    my $array_ref2 = shift;
    my $title = shift;
    mkdir("graph", 0777);
    gnuplot(
	    {"title" => opt::val("title"),
	     "output file" => 'graph/' . opt::val("filename"),
	     "x-axis label" => opt::val("x"),
	     "y-axis label" => opt::val("y")},

	    [{"title" => opt::val("title"),
	      "style" => opt::val("style"),
	      "type" => opt::val("type")},
	      $array_ref1, $array_ref2, ],
	     );
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::Graph - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::Graph;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::Graph was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
