#!/usr/bin/env perl
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#             H2v.pm odyssey
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: H2v.pm,v 1.2 2001/09/05 10:36:31 s98982km Exp $

package G::Tools::H2v;

use SubOpt;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
	     _csv_h2v
	     _h2v
);
$VERSION = '0.01';

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::
sub new{
    my $pkg = shift;
    my $filename = shift;
    my $option = shift;
    my $this;

    return $this;
}


###################################################
#  h2v                                            #
###################################################
# csv_h2v ver.20010713-01
# Author: Kazuharu "Gaou" Arakawa (gaou@g-language.org)
# Usage: 1 = &csv_h2v(string infile, string outfile);
# This program reads csv infile, reverses rows to columns.
# Requires h2v. 
sub _csv_h2v {
    my $infile = shift;
    my $outfile = shift;
    my @array = ();
    my $i = 0;
    my $j = 0;

    open(INFILE, $infile) || die ("$!");
    while(<INFILE>){
	chomp;
	@array[$i] = [split(/,/)];
	$i ++;
    }
    close(INFILE);

    &h2v(\@array);

    open(OUTFILE, '>' . $outfile) || die ("$!");
    foreach my $ref (@array){
        foreach my $cell (@$ref){
            print OUTFILE $cell . ',';
	}
	print OUTFILE "\n";
    }
    close(OUTFILE);

    return 1;
}


# h2v ver. 20010713-01
# Author: Kazuharu "Gaou" Arakawa (gaou@g-language.org)
# Usage: 1 = &h2v(pointer array_of_array);
# This program reverses the rows to columns of an array of array.
# !!!Caution!!! The array of array itself is changed!
sub _h2v {
    my $ref_array = shift;
    my $i = 0;
    my $j = 0;
    my @array = ();
    my $maxcol = 0;
    my $maxrow = 0;
 
    for ($i = 0; defined($ref_array->[$i][$j]); $i ++){
	for ($j = 0; defined($ref_array->[$i][$j]); $j ++){
	    $array[$j][$i] = $ref_array->[$i][$j];
	}
	$maxcol = $j if ($maxcol < $j);
	$j = 0;
    }
    $maxrow = $i;
 
    for ($i = 0; $i <= $maxrow; $i ++){
        @$ref_array->[$i] = ();
        for ($j = 0; $j <= $maxcol; $j ++){
            $ref_array->[$i][$j] = $array[$i][$j] if (defined($array[$i][$j]));
        }
        $j = 0;
    }
 
    return 1;
} 


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::H2v - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::H2v;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::H2v was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
