#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#     SubOpt.pm MT subroutine option parser
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: SubOpt.pm,v 1.1 2001/09/05 10:35:17 s98982km Exp $
#
# G-language System is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language System is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language System -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@g-language.org> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package opt;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     default
	     val
	     get
);
$VERSION = '0.01';

#::::::::::::::::::::::::::::::
#          Variables
#::::::::::::::::::::::::::::::

my %data;

#::::::::::::::::::::::::::::::
#           Methods
#::::::::::::::::::::::::::::::

sub default{
    %data = (@_);
}

sub val{
    my $key = shift;
    return $data{$key};
}

sub get{
    my @args = @_;
    my @new_args = ();
    my $i = 0;

    while(defined $args[$i]){
	if (substr($args[$i], 0, 1) eq '-'){
	    $data{substr($args[$i],1)} = $args[$i + 1];
	    $i += 2;
        }else{
	    push(@new_args, $args[$i]);
	    $i ++;
	}
    }

    return @new_args;
}



1;
__END__


=head1 NAME

SubOpt - MT subroutine option parser

=head1 SYNOPSIS

  use SubOpt;

  &mt ("foo", -option=>"neat!", -file=>"fancy.txt", "oops");

  sub mt{
      opt::default(option => 'none', file => 'hoge.txt');
      # Set default values. This is optional.

      my @args = opt::get(@_);
      # Parse options.

      my ($first, $last) = @args;

      print "first: $first \n last: $last\n";
      print "option: ", opt::val("option"), "\n";
      print "file: ", opt::val("file"), "\n";
      # Option values are accessed via opt::val().
  }



=head1 DESCRIPTION

  SubOpt parses the arguments given to a subroutine in a similar 
  manner as GetOpt module.

  Option specified in the form: -option=>"hoge"
  inputs the value "hoge" with a key "option".
  i.e. option with '-' is stored with the value pointed with '=>'.

  opt::get(@_) parses the option arguments, stores the options in its
  class, and returns the array of arguments that are not options.

  opt::default(<option>=><value>) sets default values for the options. 
  i.e. if the option is not specified, the value set with this method 
  is used. This method is optional.

  opt::val(<option>) returns the value of the given option.

  Although it is not necessary to use the methods with "opt::", we
  strongly recommend to do so to avoid confusion.

=head1 AUTHOR

  Kazuharu Gaou Arakawa, gaou@g-language.org

=head1 SEE ALSO

perl(1).

=cut
