#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
#     gimv.pl: G-language Manager Image Viewer core
#
#     Copyright (C) 2001 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: gimv.pl,v 1.1 2001/09/15 07:17:28 t98901ka Exp $
#
# G-language System is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language System is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language System -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Kazuharu Arakawa <gaou@g-language.org> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package gimv;

use strict;
use Gnome;
use Gtk::Gdk::ImlibImage;

init Gnome "gimv", "0.1";

;#######################################################################
;#      main
;#######################################################################

my $file = shift;

my $fs_window;
my $im = load_image Gtk::Gdk::ImlibImage($file);
my $w = $im->rgb_width;
my $h = $im->rgb_height;

my @tmp_filepath = split(/\//, $file);
my $filename = pop @tmp_filepath;

my $app = new Gnome::App "gimv", "gimv $filename";
my $canvas = Gnome::Canvas->new();
my $width = $w;
my $height = $h;
$width = 800 if ($w > 800);
$height = 600 if ($h > 600);
$canvas->set_usize($width, $height);
$canvas->set_scroll_region(-$w/2,-$h/2, $w/2, $h/2);

my $croot = $canvas->root;
my $cgroup = $croot->new($croot, "Gnome::CanvasGroup");
my $imgitem = $cgroup->new ($cgroup, "Gnome::CanvasImage", 
			    'image' => $im,
			    'x' => 0,
			    'y' => 0,
			    width => $w,
			    height => $h,
			    );

signal_connect $app 'delete_event', sub { Gtk->main_quit; return 1 };
signal_connect $app 'destroy_event', sub { Gtk->main_quit; return 1 };

my @menu_info = ({type => 'subtree',
		  label => '_File',
		  subtree => [{type => 'item',
			       label => 'Save _As...',
			       pixmap_type => 'stock',
			       pixmap_info => 'Menu_Save',
			       callback => \&create_file_selection},
			      {type => 'item',
			       label => '_Close',
			       pixmap_type => 'stock',
			       pixmap_info => 'Menu_Close',
			       callback => [sub {Gtk->main_quit;}]
			       }]}
		 );

my $sw = new Gtk::ScrolledWindow();
$sw->add($canvas);

$app->create_menus(@menu_info);
$app->set_contents($sw);
$app->show_all();
    
main Gtk;


;#######################################################################
;#      subroutines
;#######################################################################

sub create_file_selection {
    
    if (not defined $fs_window){
	$fs_window = new Gtk::FileSelection "Save As...";
	$fs_window->position(-mouse);
	$fs_window->set_filename($filename);
	$fs_window->signal_connect("destroy", 
				   [sub {hide $fs_window;}]
				   );
	$fs_window->signal_connect("delete_event", 
				   [sub {hide $fs_window;}]
				   );
	$fs_window->ok_button->signal_connect("clicked", 
					      \&save_file_event, $fs_window,
					      );
	$fs_window->cancel_button->signal_connect("clicked", 
						  [sub {hide $fs_window;}]
						  );
    }
    if (!visible $fs_window){
	show $fs_window;
    }else{
	hide $fs_window;
    }
}

sub save_file_event{
    my ($widget, $fs) = @_;
    my $fname = $fs->get_filename();
    $im->save_image($fname);

    hide $fs_window;
}


1;




