#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Alignment.pm,v 1.1.1.1 2002/04/02 20:25:44 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::Alignment;

use SubOpt;
use G::Messenger;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     _clustalw
);

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::


sub _clustalw{  
    &opt_default(input=>"file",alnfile=>"clustalw.aln",dndfile=>"clustalw.dnd",output=>"f");
    my @args=opt_get(@_);

    my $input=&opt_val("input");
    my $alnfile=&opt_val("alnfile");
    my $dndfile=&opt_val("dndfile");
    my $output=&opt_val("output");
    my $seq;
    my @param;
    my $file;
    my %opt;
    my @aln;
    my @dnd;
    my $tmp;

    if($input eq 'seq'){
	$seq=shift @args;
	open(FILE,'>/tmp/tmp.clw');
	foreach(keys(%{$seq})){
	    print FILE '>',"$_","\n";
	    print FILE ${$seq}{$_},"\n\n";
	}
	close(FILE);
	$file="/tmp/tmp.clw"; 
    }
    else{
	$file=shift @args;
    }

    foreach(sort keys(%opt)){
	next if($opt{$_} eq '');
	push(@param,'-'.$_);
	push(@param,$opt{$_});
    }

    system('clustalw',"$file",@param);

    if($input eq 'seq'){
        unlink('/tmp/tmp.clw');
	if($output eq 'n'){	    
	    open(FILE,'/tmp/tmp.aln');
	    @aln=<FILE>;
	    close(FILE);
	    open(FILE,'/tmp/tmp.dnd');
	    @dnd=<FILE>;
	    close(FILE);
	    unlink('/tmp/tmp.aln');
	    unlink('/tmp/tmp.dnd');
	    return (\@aln,\@dnd);
	}
	else{
	    system('cp','/tmp/tmp.aln',"\.\/$alnfile");
	    system('cp','/tmp/tmp.dnd',"\.\/$dndfile");
	    unlink('/tmp/tmp.aln');
	    unlink('/tmp/tmp.dnd');
	}
    } 
    else{
	if($output eq "n"){
	    $tmp=substr($file,0,rindex($file,'.')).'.aln';
	    open(FILE,$tmp);
	    @aln=<FILE>;
	    close(FILE);
	    unlink("$tmp");
	    $tmp=substr($file,0,rindex($file,'.')).'.dnd';
	    open(FILE,$tmp);
	    @dnd=<FILE>;
	    close(FILE);
	    unlink("$tmp");
	    return (\@aln,\@dnd);
	}
    }

    return $file.' '.join(' ',@param);
}

sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::Alignment - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Tools::Alignment;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::Alignment was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
