#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Cap3.pm,v 1.4 2002/08/19 17:22:45 tero Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::Tools::KEGG_API;

require Exporter;
use strict;
use SOAP::Lite;
use vars qw(@ISA @EXPORT);

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     load_kegg_api
	     );

sub new{
    my $pkg = shift;
    my $self = {};
    return bless ($self,$pkg);
}

sub load_kegg_api{
    return G::Tools::KEGG_API->new();
}

my $url = 'http://soap.genome.ad.jp/KEGG.wsdl';

sub get_all_neighbors_by_gene{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_all_neighbors_by_gene(@_);
    return $response;
}

sub get_best_best_neighbors_by_gene{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_best_best_neighbors_by_gene(@_);
    return $response;
}

sub get_best_neighbors_by_gene{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_best_neighbors_by_gene(@_);
    return $response;
}

sub get_reverse_best_neighbors_by_gene{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_reverse_best_neighbors_by_gene(@_);
    return $response;
}

sub get_paralogs_by_gene{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_paralogs_by_gene(@_);
    return $response;
}

sub get_best_homologs_by_genes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_best_homologs_by_genes(@_);
    return $response;
}

sub get_best_best_homologs_by_genes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_best_best_homologs_by_genes(@_);
    return $response;
}

sub get_score_between_genes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_score_between_genes(@_);
    return $response;
}

sub get_definition_by_gene{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_definition_by_gene(@_);
    return $response;
}

sub get_common_motifs_by_genes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_common_motifs_by_genes(@_);
    return $response;
}

sub get_genes_by_motifs{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_genes_by_motifs(@_);
    return $response;
}

sub get_genes_by_pathway{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_genes_by_pathway(@_);
    return $response;
}

sub get_compounds_by_pathway{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_compounds_by_pathway(@_);
    return $response;
}

sub get_enzymes_by_pathway{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_enzymes_by_pathway(@_);
    return $response;
}

sub get_pathways_by_genes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_pathways_by_genes(@_);
    return $response;
}

sub get_pathways_by_compounds{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_pathways_by_compounds(@_);
    return $response;
}

sub get_pathways_by_enzymes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_pathways_by_enzymes(@_);
    return $response;
}

sub get_pathways_by_reactions{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_pathways_by_reactions(@_);
    return $response;
}

sub get_reactions_by_pathways{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_reactions_by_pathways(@_);
    return $response;
}

sub get_enzymes_by_reactions{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_enzymes_by_reactions(@_);
    return $response;
}

sub get_genes_by_enzymes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_genes_by_enzymes(@_);
    return $response;
}

sub mark_all_pathways_by_genes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->mark_all_pathways_by_genes(@_);
    return $response;
}

sub mark_all_pathways_by_enzymes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->mark_all_pathways_by_enzymes(@_);
    return $response;
}

sub mark_all_pathways_by_compounds{
    shift @_;
    my $response = SOAP::Lite->service("$url")->mark_all_pathways_by_compounds(@_);
    return $response;
}

sub mark_pathway_by_genes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->mark_pathway_by_genes(@_);
    return $response;
}

sub mark_pathway_by_enzymes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->mark_pathway_by_enzymes(@_);
    return $response;
}

sub mark_pathway_by_compounds{
    shift @_;
    my $response = SOAP::Lite->service("$url")->mark_pathway_by_compounds(@_);
    return $response;
}

sub color_pathway_by_genes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->color_pathway_by_genes(@_);
    return $response;
}

sub color_pathway_by_enzymes{
    shift @_;
    my $response = SOAP::Lite->service("$url")->color_pathway_by_enzymes(@_);
    return $response;
}

sub color_pathway_by_compounds{
    shift @_;
    my $response = SOAP::Lite->service("$url")->color_pathway_by_compounds(@_);
    return $response;
}

sub get_entries{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_entries(@_);
    return $response;
}

sub get_aaseqs{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_aaseqs(@_);
    return $response;
}

sub get_ntseqs{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_ntseqs(@_);
    return $response;
}

sub get_all_genes_by_organism{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_all_genes_by_organism(@_);
    return $response;
}

sub get_num_genes_by_organism{
    shift @_;
    my $response = SOAP::Lite->service("$url")->get_num_genes_by_organism(@_);
    return $response;
}

1;

__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Tools::KEGG_API - Perl extension for blah blah blah

=head1 SYNOPSIS

    use G::Tools::KEGG_API;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Tools::KEGG_API was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
