#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: G.pm,v 1.4 2002/07/30 17:40:56 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#
# written by Atsuko Kishi <uran@g-language.org> at
# G-language Project, Institute for Advanced Biosciences, Keio University.
#

package G::DynamicLoader;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK @INC $AUTOLOAD);
use File::Find;

require Exporter;

@ISA = qw(Exporter AutoLoader);

BEGIN{

    my $path = $ENV{HOME} . '/Plug-in';
    if($ENV{GLANG_PLUGIN}){
	$path = $ENV{GLANG_PLUGIN};
	substr($path, -1, 1) = '' if(substr($path, -1, 1) eq '/');
    }
    unshift(@INC, $path);


    no strict 'refs';
    
#1. open plug-in folder
#2. search all '*.pm'
#3. for each '*.pm' do the following
    
    my $sub = 
	sub {
	    my $dir = $File::Find::name;
	    my $dirpath = $dir;
#	    print $dir, "\n";return;
	    if(-d $dir){
		$dir =~ s/^$path$/\.\//g;
		$dir =~ s/^$path\//\.\//g;
#		print $dir, " $path\n";return;
		
		my $file;
		opendir(DIR, $dirpath) || die "can't opendir $dir: $!"; 

		$dir =~ s/^\.\//\.::/g;
		$dir.="::" unless($dir=~/::$/);
		$dir =~ s/\//::/g;	
		$dir =~ s/^\.:://g;	

		while(defined($file=readdir(DIR))){
		    if($file=~/(.+)\.pm$/){
			next if ($file =~ /^\.\#/);
			my $dirname= $dir.$1;
#			print $dirname, "\n";
			eval "use $dirname";
			
			if ($@) { warn "$@"}
			
			push(@EXPORT, @{"$dirname" . '::' . "EXPORT"});	   
			
		    }
		}
		closedir(DIR);
	    }
	};

    find($sub, "$path") if (-e $path);    
}

1;

__END__











