#!/usr/bin/env perl

#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# This file is part of G-language Genome Analysis Environment package
#
#     Copyright (C) 2001-2007 Keio University
#:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
# 
#   $Id: Pathway.pm,v 1.1.1.1 2002/04/02 20:25:38 gaou Exp $
#
# G-language GAE is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# G-language GAE is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
# See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public
# License along with G-language GAE -- see the file COPYING.
# If not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
# 
#END_HEADER
#

package G::SystemsBiology::Pathway;

use SubOpt;
use G::Messenger;
use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

use SelfLoader;

require Exporter;

@ISA = qw(Exporter AutoLoader);
@EXPORT = qw(
	     _find_bad_substance
	     _find_pathway_gap
);

__DATA__

#::::::::::::::::::::::::::::::
#        Methods Start
#::::::::::::::::::::::::::::::



#find_bad_substance ver.20010525-01
#scripting by Koya Mori(s98982km@sfc.keio.ac.jp)
#This program finds bad substance from e-cell rule files.
#(array substance_list)=&find_bad_substance(string whole.eri,  string Membrane_reaction.txt,   string Analyzed_reaction.txt,   boolean debug);
sub _find_bad_substance{
    my $filename2=shift;
    my $filename3=shift;
    my $filename1=shift;
    my @RuleFileLine;
    my @HiddenSubstrate;
    my @substrate;
    my @product;
    my @MembraneSubstrate;
    my %WholeProduct;
    my $ProductName;
    my %lhash;
    my @result;

    @HiddenSubstrate=('ACCOA','ADP','AKG','AMP','ATP','CO2','COA','GLN','GLU','NAD','NADH','NADP','NADPH','NH3','PI','PPI','PYR');

    open(SFILE, $filename1)|| die("ERROR: file does not exist\n"); 
    &msg_error("open data file $filename1\n");

    while(<SFILE>){
	@RuleFileLine=split /\t/;
	if($RuleFileLine[0]!~/Type/){
	    push(@substrate,$RuleFileLine[5]) if($RuleFileLine[5]);
	    push(@product,$RuleFileLine[8]) if($RuleFileLine[8]);
	}
    }
    close(SFILE);


    open(SFILE, $filename3)|| die("ERROR: file does not exist\n"); 
    &msg_error("open data file $filename3\n");

    while(<SFILE>){
	@RuleFileLine=split /\t/;
	if($RuleFileLine[0]!~/Type/){
	    push(@MembraneSubstrate,$RuleFileLine[5]) if($RuleFileLine[5]);
	    push(@MembraneSubstrate,$RuleFileLine[8]) if($RuleFileLine[8]);
	}
    }
    close(SFILE); 
    

    open(WFILE, $filename2)|| die("ERROR: file does not exist\n"); 
    &msg_error("open data file $filename2\n");
    
    while(<WFILE>){
	@RuleFileLine=split /\t/;
	if($RuleFileLine[0] eq "REACTOR"){
	    foreach(@RuleFileLine){
		$ProductName=(split /:/)[-1] if(/Product/);
		$WholeProduct{substr($ProductName,0,-2)}=undef;
	    }
	}
    }
    close(WFILE);


    @lhash{@substrate}=undef;
    foreach(@product){
	delete $lhash{$_};
    }
    
    foreach(keys(%WholeProduct)){
	delete $lhash{$_};
    }

    foreach(@MembraneSubstrate){
	delete $lhash{$_};
    }


    @result=keys %lhash;
    return \@result;
}


#find_pathway_gap ver.20010528-01
#scripting by Koya Mori(s98982km@sfc.keio.ac.jp)
#This program finds pathway gap from e-cell rule files.
#(array substance_list)=&find_pathway_gap(string Analyzed_reaction.txt,   boolean debug);
sub _find_pathway_gap{
    my $filename=shift;
    my @RuleFileLine;
    my @HiddenSubstrate;
    my @substrate;
    my @product;
    my $ProductName;
    my %lhash;
    my @result;

    @HiddenSubstrate=('ACCOA','ADP','AKG','AMP','ATP','CO2','COA','GLN','GLU','NAD','NADH','NADP','NADPH','NH3','PI','PPI','PYR');


    open(SFILE, $filename)|| die("ERROR: file does not exist\n"); 
#    print STDERR ("open data file $filename\n");

    while(<SFILE>){
	@RuleFileLine=split /\t/;
	if($RuleFileLine[0]!~/Type/){
	    push(@substrate,$RuleFileLine[5]) if($RuleFileLine[5]);
	    push(@product,$RuleFileLine[8]) if($RuleFileLine[8]);
	}
    }
    close(SFILE);


    @lhash{@substrate}=undef;
    foreach(@product){
	delete $lhash{$_};
    }
    
    foreach(@HiddenSubstrate){
	delete $lhash{$_};
    }


    @result=keys %lhash;
    return \@result;
}


sub DESTROY {
    my $self = shift;
}

1;
__END__
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

G::Ecell::Pathway - Perl extension for blah blah blah

=head1 SYNOPSIS

  use G::Ecell::Pathway;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for G::Ecell::Pathway was created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head1 AUTHOR

A. U. Thor, a.u.thor@a.galaxy.far.far.away

=head1 SEE ALSO

perl(1).

=cut
