/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include "internal.h"
#include "dga.h"

struct ygl_dga_t ygl_dga;

void YInit_dga()
{
	int ver, rel;
	
	ygl_dga.nmodes = 0;
	if (!XDGAQueryExtension(ygl.display, &ver, &ver)) {
		PE("\tDGA: not available\n");
		return;
	}
	XDGAQueryVersion(ygl.display, &ver, &rel);
	ygl_dga.modes = XDGAQueryModes(ygl.display, ygl.screen,
		&ygl_dga.nmodes);
	if (!ygl_dga.modes) ygl_dga.nmodes = 0;
	if (ygl_dga.nmodes <= 0) {
		PE("\tDGA: %d.%d, no modes available\n", ver, rel);
		return;
	}
	PE("\tDGA: %d.%d, modes: %d\n", ver, rel, ygl_dga.nmodes);
}

void YClose_dga()
{
	XFree(ygl_dga.modes);
}


