/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include "internal.h"
#include "display.h"

struct ygl_display_t ygl = { (Display *)0 };

int YInit()
{
	XPixmapFormatValues *v;
	XKeyboardState s;
	int t, n;
	
	if (ygl.display) return(0);
	
	PE("X11:\n");
	ygl.display = XOpenDisplay(NULL);
	if (!ygl.display) { PE("\tCan't open X display\n"); return(-1); }
	ygl.screen = DefaultScreen(ygl.display);
	ygl.root_window = RootWindow(ygl.display, ygl.screen);
	ygl.default_visual = DefaultVisual(ygl.display, ygl.screen);
	ygl.default_gc = DefaultGC(ygl.display, ygl.screen);
	ygl.depth = DefaultDepth(ygl.display, ygl.screen);
	ygl.lsb_first = (ImageByteOrder(ygl.display) == LSBFirst);
	ygl.width = DisplayWidth(ygl.display, ygl.screen);
	ygl.height = DisplayHeight(ygl.display, ygl.screen);
	ygl.bits_per_pixel = ygl.scanline_pad = ygl.depth;
	
	// Pixmap formats (bits per pixel & scanline pad)
	v = XListPixmapFormats(ygl.display, &n);
	if (!v) PE("\tCan't get a list of pixmap formats\n");
	else {
		for (t=n-1; t>=0; t--) if (v[t].depth == ygl.depth) {
			ygl.bits_per_pixel = v[t].bits_per_pixel;
			ygl.scanline_pad = v[t].scanline_pad;
		}
		XFree(v);
	}
	
	// Keyboard initial autorepeat state
	XGetKeyboardControl(ygl.display, &s);
	ygl.old_autorepeat = (s.global_auto_repeat == AutoRepeatModeOn);
	
	// Dump info
	PE("\tDisplay: %dx%d, depth %d, %dbpp, pad: %dbits, %cSB first\n",
		ygl.width, ygl.height, ygl.depth, ygl.bits_per_pixel,
		ygl.scanline_pad, ygl.lsb_first ? 'L' : 'M');

	/*
	// Extensions
	YInit_xshm();
	YInit_xvideo();
	YInit_xf86vidmode();
	YInit_dga();
	YInit_glx();*/
	return(0);
}

void YClose()
{
	/*
	// Extensions
	YClose_glx();
	YClose_dga();
	YClose_xf86vidmode();
	YClose_xvideo();
	YClose_xshm();*/
	
	if (ygl.old_autorepeat) XAutoRepeatOn(ygl.display);
	else XAutoRepeatOff(ygl.display);
	XSync(ygl.display, False);
	XCloseDisplay(ygl.display);
}

void YSync()
{
	XSync(ygl.display, False); // False = no discard
}
