/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YGL2_DISPLAY_H
#define __YGL2_DISPLAY_H
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

//#include "shm.h"
//#include "xv.h"
//#include "vidmode.h"
//#include "dga.h"
//#include "gly.h"
//#include "window.h"

extern struct ygl_display_t {
	Display *display;
	int screen;
	Window root_window;
	Visual *default_visual;
	GC default_gc;
	
	int width, height;
	int depth, bits_per_pixel, scanline_pad;
	int lsb_first;
	int old_autorepeat;
} ygl;

int YInit();
void YClose();

void YSync();

/*
Memo:
	YInit/YClose_xshm();
	YInit/YClose_xvideo();
	YInit/YClose_xf86vidmode();
	YInit/YClose_dga();
	YInit/YClose_glx();

*/

#endif
