/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YGL_XSHM_H
#define __YGL_XSHM_H
#include "display.h"
#include <X11/extensions/XShm.h>

extern struct ygl_xshm_t {
	int available;
	int zpixmaps;
} ygl_xshm;

void YInit_xshm();
void YClose_xshm();

int YShmAlloc(XShmSegmentInfo *fillin, int size);
int YShmFree(XShmSegmentInfo *info);

/*
Memo:
	Pixmap XShmCreatePixmap(ygl.display, ygl.root_window,
		shm_seg.shmaddr, &shm_seg, w, h, ygl.depth);
	XFreePixmap(ygl.display, Pixmap);
	
	XImage *XShmCreateImage(ygl.display, ygl.default_visual, ygl.depth,
		ZPixmap, shm_seg.shmaddr, &shm_seg, w, h);
	XFree(XImage *);
	
	XShmPutImage(ygl.display, drawable, ygl.default_gc,
		XImage *, src_x, src_y, dst_x, dst_y, w, h, send_event:False);
	
Standard style:
	Pixmap XCreatePixmap(ygl.display, ygl.root_window, w, h, depth);
	XFreePixmap(ygl.display, Pixmap);
	
	XImage *XCreateImage(ygl.display, ygl.default_visual, ygl.depth,
		ZPixmap, offset:0, data, w, h, quantum:8, line_byte_size);
	XFree(XImage *);
	
	XPutImage(ygl.display, drawable, ygl.default_gc,
		XImage *, src_x, src_y, dst_x, dst_y, w, h);
*/
#endif
