/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include <stdlib.h>
#include "window.h"

Window YCreateWindow(int x, int y, int w, int h, int noWM, long event_mask)
{
	Window win;
	unsigned long attrmask;
	XSetWindowAttributes attr;
	
	attrmask = CWBackPixmap|CWBackingStore|CWOverrideRedirect
		|CWSaveUnder|CWEventMask;
	attr.background_pixmap = None;
	attr.backing_store = NotUseful;
	attr.override_redirect = noWM;
	attr.save_under = False;
	attr.event_mask = event_mask;

	// Create window (0 is border width)
	win = XCreateWindow(ygl.display, ygl.root_window, x, y, w, h, 0,
		ygl.depth, InputOutput, ygl.default_visual, attrmask, &attr);
	if (win != None) {
		XMapRaised(ygl.display, win);
		XSync(ygl.display, False);
	}
	return(win);
}

void YDestroyWindow(Window w)
{
	XDestroyWindow(ygl.display, w);
}

static int catchbit(Pixmap p, char *src, int w, int h, int val,
	unsigned long is, unsigned long isnot)
{
	int x, y;
	XGCValues v;
	GC gc;
	
	v.function = GXcopy;
	gc = XCreateGC(ygl.display, p, GCFunction, &v);
	if (gc == NULL) return(1);
	
	for (y=0; y<h; y++) {
		for (x=0; x<w; x++) {
			v.foreground = (*src==val) ? is : isnot;
			XChangeGC(ygl.display, gc, GCForeground, &v);
			XDrawPoint(ygl.display, p, gc, x, y);
			src++;
		}
	}
	XFreeGC(ygl.display, gc);
	return(0);
}

Cursor YCreateCursor(char *data, int w, int h, int cx, int cy,
	float r1, float g1, float b1, float r2, float g2, float b2)
{
	Cursor c;
	Pixmap src, mask;
	XColor fg, bg;
	
	// convert types
	if ((cx < 0) || (cx >= w)) cx = 0;
	if ((cy < 0) || (cy >= h)) cy = 0;
	fg.flags = bg.flags = DoRed | DoGreen | DoBlue;
	fg.red = r1*65535; fg.green = g1*65535; fg.blue = b1*65535;
	bg.red = r2*65535; bg.green = g2*65535; bg.blue = b2*65535;
	
	// create images and pixmaps
	src  = XCreatePixmap(ygl.display, ygl.root_window, w, h, 1);
	mask = XCreatePixmap(ygl.display, ygl.root_window, w, h, 1);
	if ((src==None)||(mask==None)) return(None);
	
	// twindata -> bitmapdata
	if (catchbit(src, data, w, h, 1, -1, 0)
	|   catchbit(mask, data, w, h, 0, 0, -1)) {
		XFreePixmap(ygl.display, src);
		XFreePixmap(ygl.display, mask);
		return(None);
	}
	
	// Create cursor
	c = XCreatePixmapCursor(ygl.display, src, mask, &fg, &bg, cx, cy);
	return(c);
}

void YSetName(Window w, char *name, char *icon_name)
{
	XmbSetWMProperties(ygl.display, w, name, icon_name,
		NULL, 0, NULL, NULL, NULL);
}

void YSetSizeRange(Window w, int w1, int h1, int w2, int h2)
{
	XSizeHints sz_hints;
	
	sz_hints.flags = PMinSize|PMaxSize;
	sz_hints.min_width  = w1; sz_hints.max_width  = w2;
	sz_hints.min_height = h1; sz_hints.max_height = h2;

	XmbSetWMProperties(ygl.display, w, NULL, NULL,
		NULL, 0, &sz_hints, NULL, NULL);

}

int  YGetSize(Window w, int *width, int *height)
{
	XWindowAttributes attr;

	if (!XGetWindowAttributes(ygl.display, w, &attr)) return(-1);

	if (width) *width = attr.width;
	if (height) *height = attr.height;
	return(0);
}

