/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include <stdlib.h>
#include "internal.h"
#include "xv.h"

struct ygl_xv_t ygl_xv;

void YInit_xvideo()
{
	unsigned int ver, rel, t;
	
	if (XvQueryExtension(ygl.display, &ver, &rel, &t, &t, &t)!=Success) {
		PE("\tXVideo: not available\n");
		ygl_xv.present = 0;
		return;
	}
	ygl_xv.present = 1;
	
	PE("\tXVideo: %d.%d\n", ver, rel);
	
	// Grrrrrrrrr! :-(
	ygl_xv.ap_atom =
		XInternAtom(ygl.display, "XV_AUTOPAINT_COLORKEY", True);
	if (ygl_xv.ap_atom == None)
		PE("\tNote: XV_AUTOPAINT_COLORKEY Atom not found\n");
}


void YClose_xvideo()
{
}



