/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YGL_XVIDEO_H
#define __YGL_XVIDEO_H
#include "display.h"
#include <X11/extensions/Xvlib.h>

extern struct ygl_xv_t {
	int present;
	Atom ap_atom;
} ygl_xv;

void YInit_xvideo();
void YClose_xvideo();

/*
Memo:
	XvImage *XvCreateImage(ygl.display, portid, fmtid, data, w, h);
	XvImage *XvShmCreateImage(ygl.display, portid, fmtid, shm_seg.shmaddr,
		w, h, &shm_seg);
	
	XvPutImage(ygl.display, portid, drawable, ygl.default_gc, XvImage *,
		src_x, src_y, src_w, src_h, dst_x, dst_y, dst_w, dst_h);
	XvShmPutImage(ygl.display, portid, drawable, ygl.default_gc, XvImage *,
		src_x, src_y, src_w, src_h, dst_x, dst_y, dst_w, dst_h,
		send_event:False);
	
	XvPutVideo(ygl.display, portid, drawable, ygl.default_gc,
		vid_x, vid_y, vid_w, vid_h, dst_x, dst_y, dst_w, dst_h);
	
	atom_names: XV_MUTE, XV_HUE, XV_SATURATION, XV_BRIGHTNESS,
		XV_CONTRAST, XV_FREQ, XV_ENCODING
	at = XInternAtom(ygl.display, atom_name, :True);
	if (at == None) error();
	if (XvGetPortAttribute(ygl.display, portid, at, &result)) error();
	if (XvSetPortAttribute(ygl.display, portid, at, value)) error();
*/

#endif
