/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YTK_FONTS_H
#define __YTK_FONTS_H
#include "workspace.h"

struct ytk_font {
	int width, height;
	int cst_dx, cst_dy, cst_w, cst_h;
	int iso_width;
	unsigned char *data;
	int nchars, bytes_per_line;
	struct ytk_font_char {
		int x, y, iso_x, var_x, var_w;
	} *chars;
};

typedef struct ytk_font YtkFont;

struct ytk_font *YtkFontInit(unsigned char *data, int w, int h);
void YtkFontFree(struct ytk_font *fnt);

#define FONT_DIRECT	0
#define FONT_CONSTANT	1
#define FONT_ISOMETRIC	2
#define FONT_CLOSEST	3
int YtkFontWidth(struct ytk_font *fnt, int mode, int spacing, char *str);

void YtkPrint(struct ytk_ws *ws, int dx, int dy, unsigned int color,
	struct ytk_font *fnt, int mode, int spacing, char *text);



extern char YtkPrintfBuffer[256];
#define YtkPrintf(ws,dx,dy,color,fnt,mode,spacing,s...) do { \
	snprintf(YtkPrintfBuffer, sizeof(YtkPrintfBuffer), s); \
	YtkPrintfBuffer[sizeof(YtkPrintfBuffer)-1] = 0; \
	YtkPrint(ws,dx,dy,color,fnt,mode,spacing,YtkPrintfBuffer); \
} while(0)

#endif
	

/*
// Utility function
// Warning: mallocates font->data, use free(font->data) before font_free(font)
//struct ytk_font *font_open(char *filename);

#include "../mformat/rw.h"
#include "../mformat/pnm.h"

struct font_t *font_open(char *name)
{
	int fd, sz, w, h, n;
	void *filedata, *data;
	
	fd = open(name, O_RDONLY);
	if (fd<0) return(NULL);
	sz = mfsize(fd);
	if (sz < 8) { close(fd); return(NULL); }
	filedata = malloc(sz);
	if (!filedata) { close(fd); return(NULL); }
	n = mread(fd, filedata, sz);
	close(fd);
	if (n) { free(filedata); return(NULL); }
	if (!pnm_info(filedata, &w, &h, NULL, NULL, sz))
		{ free(filedata); return(NULL); }
	data = malloc(w*h);
	if (!data) { free(filedata); return(NULL); }
	pnm_byte_align(1);
	n = pnm_read(data, M_GRAYSCALE8, filedata, sz);
	free(filedata);
	if (n < 0) { free(data); return(NULL); }
	return(font_init(data, w, h));
}


*/
