/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include <unistd.h>
#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include "internal.h"
#include "shm.h"
struct ygl_xshm_t ygl_xshm;

void YInit_xshm()
{
	int ver, rel, p;
	
	ygl_xshm.available = ygl_xshm.zpixmaps = 0;
	
	PE("\tConnection name: %s\n", DisplayString(ygl.display));
	if (DisplayString(ygl.display)) {
		if (DisplayString(ygl.display)[0] != ':') {
			PE("\tXShm: remote display; disabled\n");
			return;
		}
	}
	
	if (!XShmQueryExtension(ygl.display))
		{ PE("\tXShm: not available\n"); return; }
	
	ygl_xshm.available = 1;
	XShmQueryVersion(ygl.display, &ver, &rel, &p);
	PE("\tXShm: %d.%d, ", ver, rel);
	if (!p) { PE("no shared pixmaps\n"); return; }
	if (XShmPixmapFormat(ygl.display) == ZPixmap) {
		ygl_xshm.zpixmaps = 1;
		PE("shared pixmaps: Z format\n");
	} else	PE("shared pixmaps: XY format\n");
}

void YClose_xshm()
{
}


int YShmAlloc(XShmSegmentInfo *i, int size)
{
	i->shmid = shmget(IPC_PRIVATE, size,
		IPC_CREAT|IPC_EXCL|0777);
	if (i->shmid == -1) return(1);
	
	i->shmaddr = shmat(i->shmid, NULL, 0);
	if (i->shmaddr == ((void *)-1)) {
		shmctl(i->shmid, IPC_RMID, NULL);
		return(1);
	}
	i->readOnly = False;
	if (XShmAttach(ygl.display, i) == 0) {
		shmdt(i->shmaddr);
		shmctl(i->shmid, IPC_RMID, NULL);
		return(1);
	}
	XSync(ygl.display, False);
	// Mark it removable now to prevent memory loss
	shmctl(i->shmid, IPC_RMID, NULL);
	return(0);
}

int YShmFree(XShmSegmentInfo *i)
{
	XShmDetach(ygl.display, i);
	XSync(ygl.display, False);
	shmdt(i->shmaddr);
	//shmctl(i->shmid, IPC_RMID, NULL);
	return(0);
}

