/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#include "softcsp.h"

int YtkSoftcspSupported(int dst, int src)
{
	if (dst==YTK_DISPLAY) {
		if ((src==YTK_YU12)||(src==YTK_I420)) return(1);
		if (src==YTK_YV12) return(1);
		if (src==YTK_YUYV) return(1);
	}

	return(0);
}

static void YtkSoftcsp_411planar(struct ytk_ws *dst, struct ytk_ws *src,
	int ix, int iy, int w, int h)
{
	unsigned char *y, *u, *v, *ly, *lu, *lv;
	unsigned char *d, *ld;
	int tx, ty, sy, su, sv, dr, dg, db, psz;

	psz = ygl.bits_per_pixel >> 3;

	ly = src->data;
	if (src->csp == YTK_YV12) {
		lv = ly + (src->width * src->height);
		lu = lv + ((src->width >> 1) * (src->height >> 1));
	} else {
		lu = ly + (src->width * src->height);
		lv = lu + ((src->width >> 1) * (src->height >> 1));
	}

	ly += (iy * src->width) + ix;
	dr = ((iy>>1) * (src->width>>1)) + (ix>>1);
	lu += dr;
	lv += dr;

	ld = dst->data + (iy * dst->linesize) + (ix * psz);

	for (ty=0; ty<h; ty++) {
		d = ld;
		y = ly; u = lu; v = lv;
		for (tx=0; tx<w; tx++) {
			su = *u - 128;
			sv = *v - 128;
			sy = *y;
			db = sy + ((454*su)>>8);
			dg = sy - (((88*su)+(183*sv))>>8);
			dr = sy + ((359*sv)>>8);

			if (db < 0) db = 0; if (db > 255) db = 255;
			if (dg < 0) dg = 0; if (dg > 255) dg = 255;
			if (dr < 0) dr = 0; if (dr > 255) dr = 255;
			if (ygl.depth==24) {
				d[0] = db; d[1] = dg; d[2] = dr;
			} else if (ygl.depth==16) {
				*((unsigned short int *)dst) =
					((dr>>3)<<11)|((dg>>2)<<5)|(db>>3);
			} else if (ygl.depth==15) {
				*((unsigned short int *)dst) =
					((dr>>3)<<10)|((dg>>3)<<5)|(db>>3);
			}

			y++;
			if ((ix+tx)&1) { u++; v++; }
			d += psz;
		}
		ld += dst->linesize;
		ly += src->width;
		if ((iy+ty)&1) {
			lu += (src->width>>1);
			lv += (src->width>>1);
		}
	}

}

static void YtkSoftcsp_422packed(struct ytk_ws *dst, struct ytk_ws *src,
	int ix, int iy, int w, int h)
{
	unsigned char *s, *ls;
	unsigned char *d, *ld;
	int tx, ty, sy, su, sv, dr, dg, db, psz;

	psz = ygl.bits_per_pixel >> 3;

	ls = src->data + (((iy * src->width) + ix) << 1);
	ld = dst->data + (iy * dst->linesize) + (ix * psz);
	su = sv = 0; // just to avoid warnings

	for (ty=0; ty<h; ty++) {
		s = ls;
		d = ld;
		if (ix & 1) {
			su = s[-1] - 128;
			sv = s[1] - 128;
		}
		for (tx=0; tx<w; tx++) {
			sy = *s;
			if (!((ix + tx) & 1)) {
				su = s[1] - 128;
				sv = s[3] - 128;
			}
			db = sy + ((454*su)>>8);
			dg = sy - (((88*su)+(183*sv))>>8);
			dr = sy + ((359*sv)>>8);

			if (db < 0) db = 0; if (db > 255) db = 255;
			if (dg < 0) dg = 0; if (dg > 255) dg = 255;
			if (dr < 0) dr = 0; if (dr > 255) dr = 255;
			if (ygl.depth==24) {
				d[0] = db; d[1] = dg; d[2] = dr;
			} else if (ygl.depth==16) {
				*((unsigned short int *)dst) =
					((dr>>3)<<11)|((dg>>2)<<5)|(db>>3);
			} else if (ygl.depth==15) {
				*((unsigned short int *)dst) =
					((dr>>3)<<10)|((dg>>3)<<5)|(db>>3);
			}

			s += 2;
			d += psz;
		}
		ld += dst->linesize;
		ls += (src->width<<1);
	}

}

void YtkSoftcsp(struct ytk_ws *dst, struct ytk_ws *src,
	int ix, int iy, int w, int h)
{
	switch(src->csp) {
	case YTK_YV12:
	case YTK_YU12:
	case YTK_I420:
		YtkSoftcsp_411planar(dst, src, ix, iy, w, h);
		break;
	case YTK_YUYV:
	case YTK_YUY2:
		YtkSoftcsp_422packed(dst, src, ix, iy, w, h);
		break;
	default:
		break;
	}
}
