/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YGL_XF86VIDMODE_H
#define __YGL_XF86VIDMODE_H
#include "display.h"
#include <X11/extensions/xf86vmode.h>

extern struct ygl_vidmode_t {
	int nmodes;
	XF86VidModeModeInfo **modes;
} ygl_vm;

void YInit_xf86vidmode();
void YClose_xf86vidmode();

/*
Memo:
	ygl_vm.modes[n]
		->hdisplay, ->vdisplay,
		->dotclock [kHz], ->htotal, ->vtotal
		->flags

	hrefresh = dotclock / htotal;
	vrefresh = dotclock / (htotal * vtotal);
	(flags & 0x20) -> doublescan ??? FLAGS VALUES ???
	
	XF86VidModeLockModeSwitch(ygl.display, ygl.screen, 0/1);
	if (!XF86VidModeSwitchToMode(ygl.display, ygl.screen, ygl_vm.modes[n]))
		error();
	if (!XF86VidModeSetViewPort(ygl.display, ygl.screen, x, y)) error();
	
	{
		XF86VidModeGamma c;
		
		c.red = c.green = c.blue = (float)1.0;
		if (!XF86VidModeGet/SetGamma(ygl.display, ygl.screen, &c))
			error();
	}
	
*/
#endif
