/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YGL2_WINDOW_H
#define __YGL2_WINDOW_H
#include "display.h"

#define YGL_FULL_EVENT_MASK \
	KeyPressMask|KeyReleaseMask|ButtonPressMask \
	|ButtonReleaseMask|PointerMotionMask|KeymapStateMask \
	|EnterWindowMask|LeaveWindowMask|FocusChangeMask \
	|ExposureMask|StructureNotifyMask

// Returns None on failure
Window YCreateWindow(int x, int y, int w, int h, int noWM, long event_mask);

void YDestroyWindow(Window w);

Cursor YCreateCursor(char *data, int w, int h, int cx, int cy,
	float r1, float g1, float b1, float r2, float g2, float b2);
void YSetName(Window w, char *name, char *icon_name);
void YSetSizeRange(Window w, int w1, int h1, int w2, int h2);
int  YGetSize(Window w, int *width, int *height);

/*
Memo:
	// Sync
	XMapRaised(ygl.display, w);
	XSync(ygl.display, False);
	
	// Basic
	XMoveWindow(ygl.display, window, x, y);
	XResizeWindow(ygl.display, window, w, h);
	XCopyArea(ygl.display, w_src, w_dst,
		ygl.default_gc, x, y, w, h, dx, dy);
	XDestroyWindow(ygl.display, window);
	XGetGeometry(ygl.display, drawable, int *root, int *x, int *y,
		int *w, int *h, int *border, int *depth);
	
	// Cursor:
	XDefineCursor(ygl.display, Window, Cursor);
	XFlush(ygl.display);
	XFreeCursor(ygl.display, Cursor);

*/

#endif
