/*
    Copyright (C) 2006  Laurent Poirrier

    This file is part of YGL2.

    YGL2 is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    YGL2 is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*/

#ifndef __YTK_WORKSPACES_H
#define __YTK_WORKSPACES_H
#include "display.h"
#include "shm.h"
#include "xv.h"

#define YTK_SHMPIXMAP	1
#define YTK_SHMIMAGE	2
#define YTK_PIXMAP	4
#define YTK_IMAGE	8
#define YTK_XVSHMIMAGE	16
#define YTK_XVIMAGE	32
#define YTK_SOFTCSP	64

#define YTK_RGBIMAGE	(YTK_SHMPIXMAP|YTK_SHMIMAGE|YTK_IMAGE)
#define YTK_CSPIMAGE	(YTK_XVSHMIMAGE|YTK_XVIMAGE|YTK_SOFTCSP)
#define YTK_SCALABLE	(YTK_XVSHMIMAGE|YTK_XVIMAGE)

struct ytk_ws {
	int type, csp;
	int width, height, linesize, size;
	void *data;
	union {
		Pixmap pixmap;
		XImage *image;
		struct {
			XvImage *xvimage;
			int portid;
		} xv;
		struct ytk_ws *softcsp;
	} i;
	XShmSegmentInfo shm;
};

typedef struct ytk_ws Workspace;

// Display (RGB) colorspace
#define YTK_DISPLAY	0
// Planar YUV colorspaces
#define YTK_YV12	0x32315659
#define YTK_YU12	0x32315559
#define YTK_I420	0x30323449
// Packed YUV colorspaces
#define YTK_YUY2	0x32595559
#define YTK_YUYV	0x56595559
#define YTK_UYVY	0x59565955
// Other
#define YTK_RGB32	0x3

int  YtkCreateWorkspace(struct ytk_ws *ws, int type, int w, int h, int csp);
void YtkDestroyWorkspace(struct ytk_ws *ws);
void YtkPutWorkspace(struct ytk_ws *ws, Drawable d, int dx, int dy,
	int sx, int sy, int w, int h);
void YtkPutExtWorkspace(struct ytk_ws *ws, Drawable d,
	int dx, int dy, int dw, int dh, int sx, int sy, int sw, int sh);


// Mutual exclusion: use only one Xv image per Xv port
void YtkSetXvExclusion(int yes);

#endif
