#include "hm12.h"

void hm12_to_yv12(unsigned char *d, unsigned char *s, int w, int h)
{
	int pixs, blocks, b, bx, by, x, y, ax, ay;
	unsigned char *d2;

	pixs = w*h;
	blocks = pixs >> 8;

	bx = by = 0;
	for (b=0; b<blocks; b++) {
		for (y=0; y<16; y++)
		for (x=0; x<16; x++) {
			ax = bx+x; ay = by+y;
			d[(ay*w)+ax] = *s;
			s++;
		}
		bx += 16;
		if (bx >= w) {
			bx = 0;
			by += 16;
		}
	}

	d += pixs;
	w >>= 1; h >>= 1;
	pixs >>= 2;
	blocks = pixs>>6;
	d2 = d + pixs;

	bx = by = 0;
	for (b=0; b<blocks; b++) {
		for (y=0; y<8; y++)
		for (x=0; x<8; x++) {
			ax = bx+x; ay = by+y;
			d2[(ay*w)+ax] = s[0];
			d[(ay*w)+ax] = s[1];
			s+=2;
		}
		
		switch(b & 3) {
		case 0:
			by += 8;
			break;
		case 1:
			by -=8;
			bx += 8;
			break;
		case 2:
			by += 8;
			break;
		case 3:
			bx += 8;
			by -= 8;
			break;
		}
		if (bx >= w) { bx = 0; by += 16; }
		if (bx < 0) { bx = w - 8; by -= 16; }
	}
}

