#ifndef __VIDEO_IN_H
#define __VIDEO_IN_H

/*

Here are numeric values for some fourccs.
Their definition in <linux/videodev2.h> is of the form V4L2_PIX_FMT_*,
but beware of (the plenty of) inconsistencies.

*/

#define VIDEO_YUYV	0x56595559
#define VIDEO_YU12	0x32315559
#define VIDEO_YV12	0x32315659
#define VIDEO_MJPG	0x47504a4d
#define VIDEO_HM12	0x32314d48
#define VIDEO_YUV	0x00565559

#define IOMETHOD_READWRITE	0
#define IOMETHOD_STREAMING	1

typedef struct {
	int fd;
	int width, height;
	int size, fourcc;

	// Private
	char *device;
	int iomethod;
	void *m_data;
} video_device;


// ******************************************************************
// main functions
// ******************************************************************
int   video_init(video_device *vi, int w, int h, int fourcc, char *device);
void *video_capture(video_device *vi);
void  video_shutdown(video_device *vi);

int   video_control(video_device *vi, int id, int relative, int value);

/*

Commonly used V4L2 control ids:
	V4L2_CID_BRIGHTNESS, V4L2_CID_CONTRAST, V4L2_CID_SATURATION,
	V4L2_CID_GAIN

Specific to UVC video driver:
	V4L2_CID_SHARPNESS
	V4L2_CID_EXPOSURE_AUTO, V4L2_CID_EXPOSURE_ABSOLUTE,
	V4L2_CID_WHITE_BALANCE_TEMPERATURE_AUTO,
	V4L2_CID_WHITE_BALANCE_TEMPERATURE
	V4L2_CID_PAN_RELATIVE, V4L2_CID_TILT_RELATIVE, V4L2_CID_PANTILT_RESET

Common controls _not_ supported by UVC video driver:
	V4L2_CID_AUTO_WHITE_BALANCE, V4L2_CID_RED_BALANCE,
	V4L2_CID_BLUE_BALANCE, V4L2_CID_AUTOGAIN, V4L2_CID_GAMMA,
	V4L2_CID_EXPOSURE

*/


// ******************************************************************
// utilities
// ******************************************************************
/*int   video_move(video_device *vi, int pan, int tilt);
int   video_position_reset(video_device *vi);*/

int   videofile_init(video_device *vi, int w, int h, int fourcc, int size,
	char *file);


#endif

