#ifndef __YGL2_DISPLAY_H
#define __YGL2_DISPLAY_H
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "shm.h"
#include "xv.h"
#include "vidmode.h"
#include "dga.h"
#include "gly.h"
#include "window.h"

#define PE(s...)	fprintf(stderr, s)

extern struct ygl_display_t {
	Display *display;
	int screen;
	Window root_window;
	Visual *default_visual;
	GC default_gc;
	
	int width, height;
	int depth, bits_per_pixel, scanline_pad;
	int lsb_first;
	int old_autorepeat;
} ygl;

int YInit();
void YClose();

/*
Memo:
	XSync(ygl.display, discard=True/False);
*/

#endif
