#include <unistd.h>
#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include "shm.h"
struct ygl_xshm_t ygl_xshm;

void YInit_xshm()
{
	int ver, rel, p;
	
	ygl_xshm.available = ygl_xshm.zpixmaps = 0;
	
	if (!XShmQueryExtension(ygl.display))
		{ PE("\tXShm: not available\n"); return; }
	
	ygl_xshm.available = 1;
	XShmQueryVersion(ygl.display, &ver, &rel, &p);
	PE("\tXShm: %d.%d, ", ver, rel);
	if (!p) { PE("no shared pixmaps\n"); return; }
	if (XShmPixmapFormat(ygl.display) == ZPixmap) {
		ygl_xshm.zpixmaps = 1;
		PE("shared pixmaps: Z format\n");
	} else	PE("shared pixmaps: XY format\n");
}

void YClose_xshm()
{
}


int YShmAlloc(XShmSegmentInfo *i, int size)
{
	i->shmid = shmget(IPC_PRIVATE, size,
		IPC_CREAT|IPC_EXCL|0777);
	if (i->shmid == -1) return(1);
	
	i->shmaddr = shmat(i->shmid, NULL, 0);
	if (i->shmaddr == ((void *)-1)) {
		shmctl(i->shmid, IPC_RMID, NULL);
		return(1);
	}
	i->readOnly = False;
	if (XShmAttach(ygl.display, i) == 0) {
		shmdt(i->shmaddr);
		shmctl(i->shmid, IPC_RMID, NULL);
		return(1);
	}
	XSync(ygl.display, False);
	// Mark it removable now to prevent memory loss
	shmctl(i->shmid, IPC_RMID, NULL);
	return(0);
}

int YShmFree(XShmSegmentInfo *i)
{
	XShmDetach(ygl.display, i);
	XSync(ygl.display, False);
	shmdt(i->shmaddr);
	//shmctl(i->shmid, IPC_RMID, NULL);
	return(0);
}

