#ifndef __YGL_XF86VIDMODE_H
#define __YGL_XF86VIDMODE_H
#include "display.h"
#include <X11/extensions/xf86vmode.h>

extern struct ygl_vidmode_t {
	int nmodes;
	XF86VidModeModeInfo **modes;
} ygl_vm;

void YInit_xf86vidmode();
void YClose_xf86vidmode();

/*
Memo:
	ygl_vm.modes[n]
		->hdisplay, ->vdisplay,
		->dotclock [kHz], ->htotal, ->vtotal
		->flags

	hrefresh = dotclock / htotal;
	vrefresh = dotclock / (htotal * vtotal);
	(flags & 0x20) -> doublescan ??? FLAGS VALUES ???
	
	XF86VidModeLockModeSwitch(ygl.display, ygl.screen, 0/1);
	if (!XF86VidModeSwitchToMode(ygl.display, ygl.screen, ygl_vm.modes[n]))
		error();
	if (!XF86VidModeSetViewPort(ygl.display, ygl.screen, x, y)) error();
	
	{
		XF86VidModeGamma c;
		
		c.red = c.green = c.blue = (float)1.0;
		if (!XF86VidModeGet/SetGamma(ygl.display, ygl.screen, &c))
			error();
	}
	
*/
#endif
