#include <stdlib.h>
#include "window.h"

static int catchbit(Pixmap p, char *src, int w, int h, int val,
	unsigned long is, unsigned long isnot)
{
	int x, y;
	XGCValues v;
	GC gc;
	
	v.function = GXcopy;
	gc = XCreateGC(ygl.display, p, GCFunction, &v);
	if (gc == NULL) return(1);
	
	for (y=0; y<h; y++) {
		for (x=0; x<w; x++) {
			v.foreground = (*src==val) ? is : isnot;
			XChangeGC(ygl.display, gc, GCForeground, &v);
			XDrawPoint(ygl.display, p, gc, x, y);
			src++;
		}
	}
	XFreeGC(ygl.display, gc);
	return(0);
}

Cursor YCreateCursor(char *data, int w, int h, int cx, int cy,
	float r1, float g1, float b1, float r2, float g2, float b2)
{
	Cursor c;
	Pixmap src, mask;
	XColor fg, bg;
	
	// convert types
	if ((cx < 0) || (cx >= w)) cx = 0;
	if ((cy < 0) || (cy >= h)) cy = 0;
	fg.flags = bg.flags = DoRed | DoGreen | DoBlue;
	fg.red = r1*65535; fg.green = g1*65535; fg.blue = b1*65535;
	bg.red = r2*65535; bg.green = g2*65535; bg.blue = b2*65535;
	
	// create images and pixmaps
	src  = XCreatePixmap(ygl.display, ygl.root_window, w, h, 1);
	mask = XCreatePixmap(ygl.display, ygl.root_window, w, h, 1);
	if ((src==None)||(mask==None)) return(None);
	
	// twindata -> bitmapdata
	if (catchbit(src, data, w, h, 1, -1, 0)
	|   catchbit(mask, data, w, h, 0, 0, -1)) {
		XFreePixmap(ygl.display, src);
		XFreePixmap(ygl.display, mask);
		return(None);
	}
	
	// Create cursor
	c = XCreatePixmapCursor(ygl.display, src, mask, &fg, &bg, cx, cy);
	return(c);
}

void YSetName(Window w, char *name, char *icon_name)
{
	XmbSetWMProperties(ygl.display, w, name, icon_name,
		NULL, 0, NULL, NULL, NULL);
}

