#ifndef __YGL_XVIDEO_H
#define __YGL_XVIDEO_H
#include "display.h"
#include <X11/extensions/Xvlib.h>

extern struct ygl_xv_t {
	int nadaptors;
	XvAdaptorInfo *adaptors;
	int nports;
	struct ygl_xv_port_t {
		XvPortID id;
		XvAdaptorInfo *adaptor;
		int nformats;
		XvImageFormatValues *formats;
		int nencodings;
		XvEncodingInfo *encodings;
	} *ports;
} ygl_xv;

void YInit_xvideo();
void YClose_xvideo();

/*
Memo:
	XvImage *XvCreateImage(ygl.display, portid, fmtid, data, w, h);
	XvImage *XvShmCreateImage(ygl.display, portid, fmtid, shm_seg.shmaddr,
		w, h, &shm_seg);
	
	XvPutImage(ygl.display, portid, drawable, ygl.default_gc, XvImage *,
		src_x, src_y, src_w, src_h, dst_x, dst_y, dst_w, dst_h);
	XvShmPutImage(ygl.display, portid, drawable, ygl.default_gc, XvImage *,
		src_x, src_y, src_w, src_h, dst_x, dst_y, dst_w, dst_h,
		send_event:False);
	
	XvPutVideo(ygl.display, portid, drawable, ygl.default_gc,
		vid_x, vid_y, vid_w, vid_h, dst_x, dst_y, dst_w, dst_h);
	
	atom_names: XV_MUTE, XV_HUE, XV_SATURATION, XV_BRIGHTNESS,
		XV_CONTRAST, XV_FREQ, XV_ENCODING
	at = XInternAtom(ygl.display, atom_name, :True);
	if (at == None) error();
	if (XvGetPortAttribute(ygl.display, portid, at, &result)) error();
	if (XvSetPortAttribute(ygl.display, portid, at, value)) error();
*/

#endif
