#include <stdio.h>
#include <string.h>
#include "rw.h"
#include "timer.h"
#include "driver_log.h"
#include "driver_main.h"
#include "driver_cooker.h"

// *******************************************
// Generic cooker
// *******************************************
void cook_yes()
{
	int b;
	
	if (out_cooked_fd < 0) return;
	b = 0;
	bwrite(out_cooked_fd, &b, 4);
}

void cook_no()
{
	int b;
	
	if (out_cooked_fd < 0) return;
	b = -1;
	bwrite(out_cooked_fd, &b, 4);
}


// *******************************************
// Data cooker
// *******************************************
static int offset, next_idx, data_start;
static char block[512];
static char topipe[512];

void cook_init_data()
{
	offset = 0;
	next_idx = 0;
	data_start = timer_ms();
}

void cook_stop_data()
{
	short b;
	
	if (out_cooked_fd < 0) return;
	b = 0;
	bwrite(out_cooked_fd, &b, 2);
}

int  cook_sync_data()
{
	int r;
	r = offset;
	offset = 0;
	return(r);
}

static int cook_block()
{
	unsigned int idx, c, t;
	short given_sum, sum;
	void *p;
	
	if (((short *)block)[0] != 0x0201) {
		logf("Warning: Error on header\n");
		return(COOK_REPEAT);
	}
	given_sum = ((short *)block)[81];
	idx = ((unsigned short *)block)[82];
	if (((short *)block)[83] != 0x1703) {
		logf("Warning: Error on tail\n");
		return(COOK_REPEAT);
	}
	
	sum = 0;
	for (t=1; t<=80; t++) {
		sum ^= ((short *)block)[t];
	}
	/*XXX if (sum != given_sum) {
		logf("Warning: Checksum mismatch\n");
		return(COOK_REPEAT);
	} */
	
	if (idx == ((next_idx-1)&0xffff))
		logf("Warning: unexpected 2nd block %d (expected %d)\n",
			idx, next_idx);
	if (idx != next_idx)
		logf("Warning: non-continuous indexes (%d->%d)\n",
			(next_idx-1)&0xffff, idx);
	next_idx = (idx + 1) & 0xffff;
	
	if (out_cooked_fd < 0) return(COOK_SYNC);
	
	// Parse block
	sum = 178; // 7*2 + (4*10*2 + 2*20*2 + 1*1*4)
	((short *)topipe)[0] = sum;
	p = topipe + 2;
	for (c=0; c<=3; c++) {
		*((short *)p) = c | (10 << 8);
		p+=2;
		for (t=0; t<10; t++) {
			*((short *)p) = ((short *)block)[1+c+(t*8)];
			p += 2;
		}
	}
	for (c=4; c<=5; c++) {
		*((short *)p) = c | (20 << 8);
		p += 2;
		for (t=0; t<10; t++) {
			*((short *)p) = ((short *)block)[1+c+(t*8)];
			p += 2;
			*((short *)p) = ((short *)block)[1+(c+2)+(t*8)];
			p += 2;
		}
	}
	*((short *)p) = 6 | (1<<8);
	p += 2;
	*((int *)p) = timer_ms() - data_start;
	
	// Write to pipe
	if (bwrite(out_cooked_fd, topipe, sum+2)) {
		out_cooked_fd = -1;
		return(COOK_ERROR);
	}
	return(COOK_SYNC);
}

int cook_data(void *data, int n)
{
	int sz, r;
	
	if (n <= 0) return(COOK_WAIT);
	
	// Sync char
	if ((offset==0) && (n == 1)) {
		if (*((char *)data) == 0x05) {
			offset = 0;
			return(COOK_SYNC);
		}
	}
	
	// Block in progress
	if (offset + n < 168) {
		memcpy(block+offset, data, n);
		offset += n;
		return(COOK_WAIT);
	}
	
	// Block full
	sz = 168-offset;
	memcpy(block+offset, data, sz);
	r = cook_block();
	offset = 0;
	if ((sz!=n)&&(r!=COOK_ERROR)) {
		logf("Warning: Sync lost\n");
		return(COOK_RESYNC);
	}
	return(r);
}


