#include <stdio.h>
#include "rw.h"
#include "timer.h"
#include "driver_main.h"
#include "driver_log.h"


int dump_type = DUMP_NORMAL;

static int timer_start, timer_last, device_last, offset_last;
void log_init()
{
	timer_start = 0xffffffff;
	timer_last = timer_ms();
	device_last = 1;
	offset_last = 0;
}

void log_data(int device, int cmd_mode, void *data, int sz)
{
	unsigned int c;
	int timer_cur, t;
	
	timer_cur = timer_ms();
	if ((out_pseudo_fd >= 0) && (!cmd_mode)) {
		if (timer_start == 0xffffffff)
			timer_start = timer_cur;
		t = (device) ? -sz : sz;
		bwrite(out_pseudo_fd, &t, 4);
		t = timer_cur - timer_start;
		bwrite(out_pseudo_fd, &t, 4);
		bwrite(out_pseudo_fd, data, sz);
	}
	
	if ((dump_type == DUMP_NORMAL)||(dump_type == DUMP_NONE))
		return;
	
	if (dump_type == DUMP_TIME) {
		if (timer_cur != timer_last) {
			PO("Delay: %dms\n", timer_cur-timer_last);
			timer_last = timer_cur;
		}
		PO("%s: %d bytes\n", device?"embla":"somno", sz);
		if (cmd_mode) {
			PO("\t(");
			for (t=0; t<sz; t++) {
				c = ((unsigned char *)data)[t];
				PO(((c>=32)&&(c<128))?"%c":"{0x%02x}", c);
			}
			PO(")\n");
		}
		return;
	}
	
	if (cmd_mode) {
		if ((device != 0) != (device_last != 0)) {
			PO("[%s]: ", device?"embla":"somno");
			device_last = device;
		}
		for (t=0; t<sz; t++) {
			c = ((unsigned char *)data)[t];
			PO(((c>=32)&&(c<128))?"%c":"{0x%02x}", c);
			if ((c==0x05)||(c==0x0d)||(c==0x06)) PO("\n");
		}
		return;
	}
	
	if (!device) {
		PO("\n[somno]: ");
		for (t=0; t<sz; t++) {
			c = ((unsigned char *)data)[t];
			PO("0x%02x ", c);
		}
		PO("\n");
		offset_last = 0;
		return;
	}
		
	for (t=0; t<sz; t++) {
		c = ((unsigned char *)data)[t];
		PO("0x%02x ", c);
		offset_last++;
		if (offset_last >= 8) {
			offset_last = 0;
			PO("\n");
		}
	}
	return;
}

