#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include "timer.h"
#include "rw.h"
#include "commands.h"
#include "driver_main.h"
#include "driver_log.h"
#include "driver_cooker.h"
#include "driver_embla_cmd.h"
#include "driver_serial.h"
#include "driver_master.h"

static char buff[256];
int aq_request()
{
	fd_set sel;
	int n, fd_max, cmd, b;
	int errors;
	
	fd_max = (in_embla_fd > out_cooked_fd) ? in_embla_fd : out_cooked_fd;
	if (embla_acquire_start()) { cook_no(); return(1); }
	if (serial_setup(in_embla_fd, 57600)) { cook_no(); return(1); }
	logf("*** Data mode OK ***\n");
	cook_yes();
	cook_init_data();
	errors = 0;
	
	sleep_ms(150);
	b = 0x06;
	log_data(0, 0, &b, 1);
	if (bwrite(in_embla_fd, &b, 1)) {
		cook_stop_data();
		return(-1);
	}
	
	while(1) {
		FD_ZERO(&sel);
		FD_SET(in_embla_fd, &sel);
		FD_SET(out_cooked_fd, &sel);
		if (select(fd_max+1, &sel, NULL, NULL, NULL) < 0) {
			PE("Select error: %s\n", strerror(errno));
			return(1);
		}
		
		if (FD_ISSET(in_embla_fd, &sel)) {
			n = read(in_embla_fd, buff, sizeof(buff));
			if (n <= 0) {
				PE("Read error (embla): %s\n",
					strerror(errno));
				cook_stop_data();
				return(1);
			}
			log_data(1, 0, buff, n);
			cmd = cook_data(buff, n);
			if ((cmd == COOK_SYNC)||(cmd == COOK_RESYNC)
			 || (cmd == COOK_REPEAT)) {
				if (cmd==COOK_SYNC) {
					if (errors) errors--;
				} else {
					errors++;
					if (errors > 15) {
						logf("Too many errors\n");
						cook_stop_data();
						return(1);
					}
				}
				//if (cmd == COOK_REPEAT) b = ??????
				b = 0x06;
				log_data(0, 0, &b, 1);
				if (bwrite(in_embla_fd, &b, 1)) {
					cook_stop_data();
					return(1);
				}
			} else if (cmd == COOK_ERROR) {
				PE("Error on stream\n");
				cook_stop_data();
				return(1);
			}
		}
		
		if (FD_ISSET(out_cooked_fd, &sel)) {
			if (bread(out_cooked_fd, &cmd, 4)) return(1);
			if (cmd != DRV_AQ_STOP) return(1);
			cook_stop_data();
			buff[0] = 0x04;
			buff[1] = 0xe5;
			buff[2] = 0x80;
			buff[3] = 0x1c;
			buff[4] = 0x00;
			n = 5;
			log_data(0, 0, buff, n);
			if (bwrite(in_embla_fd, buff, n)) return(1);
			logf("*** ENDED ***\n");
			return(0);
		}
	}
}

int driver_master()
{
	int cmd;
	
	while(1) {
		if (serial_setup(in_embla_fd, 19200)) return(1);
		if (bread(out_cooked_fd, &cmd, 4)) return(1);
		
		if (cmd == DRV_QUIT) return(0);
		if (cmd == DRV_DETECT) {
			if (embla_detect()) {
				logf("Device is not responding\n");
				cook_no();
			} else {
				logf("Device detected\n");
				cook_yes();
			}
		} else if (cmd == DRV_IC_START) cook_no();
		else if (cmd == DRV_AQ_START) aq_request();
		else {
			PE("Unknown command 0x%08x !\n", cmd);
			cook_no();
		}
	}
}
