#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <termios.h>
#include "driver_log.h"
#include "driver_serial.h"

int serial_setup(int fd, int speed)
{
	struct termios h;
	speed_t s;
	
	if (tcgetattr(fd, &h)) {
		PE("tcgetattr(): %s\n", strerror(errno));
		return(-1);
	}
	h.c_iflag &= ~(IGNBRK|BRKINT|INPCK|PARMRK|ISTRIP
		|INLCR|IGNCR|ICRNL|IXON|IXOFF|IXANY);
	h.c_oflag &= ~OPOST;
	h.c_lflag &= ~(ECHO|ECHONL|ECHOE|ICANON|ISIG|IEXTEN);
	h.c_cflag &= ~(CSIZE|PARENB|CSTOPB|PARODD|HUPCL);
	h.c_cflag |= CLOCAL|CREAD|CS8;
	h.c_cc[VMIN] = 1;
	h.c_cc[VTIME] = 0;
	if (speed == 19200) s = B19200;
	else if (speed == 57600) s = B57600;
	else {
		PE("BUG: speed %d not implemented\n", speed);
		return(-1);
	}
	cfsetispeed(&h, s);
	cfsetospeed(&h, s);
	if (tcsetattr(fd, TCSADRAIN, &h)) {
		PE("tcsetattr(): %s\n", strerror(errno));
		return(-1);
	}
	return(0);
}
