#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include "rw.h"
#include "timer.h"
#include "commands.h"
#include "driver_main.h"
#include "driver_cooker.h"
#include "driver_serial.h"
#include "driver_log.h"
#include "driver_sniffer.h"

// ****************** History management
void history_init(void *h, int sz)
{
	memset(h, 0, sz);
}

void history_add(void *h, int sz, void *b, int n)
{
	if (n > sz) {
		PE("BUG: history overflow (%d/%d)\n", n, sz);
		memcpy(h, b+n-sz, sz);
	} else {
		memmove(h, h+n, sz-n);
		memcpy(h+sz-n, b, n);
	}
}

int history_last(void *h, int sz, void *b, int n)
{
	if (n > sz) {
		PE("BUG: history cmp too long (%d/%d)\n", n, sz);
		return(0);
	}
	return(!memcmp(h + sz - n, b, n));
}


// ****************** Basic control
int basic_control()
{
	int c;
	
	if (out_cooked_fd < 0) return(0);
	while(1) {
		if (bread(out_cooked_fd, &c, 4)) return(1);
		if (c == DRV_AQ_START) return(0);
		else cook_no();
	}
}

// ****************** Sniffer
static char hist[256];
static char buff[256];
static char to_data[21] = "P160 BAUDRATE=57600\r";
static char to_cmd[5] = { 0x04, 0xe5, 0x80, 0x1c, 0x00 };

int driver_sniffer()
{
	fd_set sel;
	int n, fd_max, cmd_mode;
	
	history_init(hist, sizeof(hist));
	cmd_mode = 1;
	if (serial_setup(in_embla_fd, 19200)) return(1);
	if (serial_setup(in_somno_fd, 19200)) return(1);
	
	fd_max = (in_embla_fd > in_somno_fd) ? in_embla_fd : in_somno_fd;
	
	if (basic_control()) return(1);
	
	while(1) {
		FD_ZERO(&sel);
		FD_SET(in_embla_fd, &sel);
		FD_SET(in_somno_fd, &sel);
		if (select(fd_max+1, &sel, NULL, NULL, NULL) < 0) {
			PE("Select error: %s\n", strerror(errno));
			return(1);
		}
		
		if (FD_ISSET(in_embla_fd, &sel)) {
			n = read(in_embla_fd, buff, sizeof(buff));
			if (n <= 0) {
				PE("Read error (embla): %s\n",
					strerror(errno));
				return(1);
			}
			if (bwrite(in_somno_fd, buff, n)) return(1);
			log_data(1, cmd_mode, buff, n);
			
			if (cmd_mode) {
				history_add(hist, sizeof(hist), buff, n);
				if (history_last(hist, sizeof(hist),
				to_data, sizeof(to_data)-1)) {
					history_init(hist, sizeof(hist));
					cmd_mode = 0;
					if (serial_setup(in_embla_fd, 57600))
						return(1);
					if (serial_setup(in_somno_fd, 57600))
						return(1);
					cook_yes();
					cook_init_data();
					logf("*** DATA MODE ***\n");
				}
			} else cook_data(buff, n);
		}
		
		if (FD_ISSET(in_somno_fd, &sel)) {
			n = read(in_somno_fd, buff, sizeof(buff));
			if (n <= 0) {
				PE("Read error (somno): %s\n",
					strerror(errno));
				return(1);
			}
			if (bwrite(in_embla_fd, buff, n)) return(1);
			log_data(0, cmd_mode, buff, n);
			
			if (!cmd_mode) {
				history_add(hist, sizeof(hist), buff, n);
				if (history_last(hist, sizeof(hist),
				to_cmd, sizeof(to_cmd))) {
					history_init(hist, sizeof(hist));
					cmd_mode = 1;
					if (serial_setup(in_embla_fd, 19200))
						return(1);
					if (serial_setup(in_somno_fd, 19200))
						return(1);
					logf("*** COMMAND MODE ***\n");
					cook_stop_data();
					if (basic_control()) return(1);
				}
			}
		}
	}
}

// ****************** Pseudo embla
int driver_pseudo()
{
	int n, sz, timer_cur, timer_start, t, dev;
	
	if (basic_control()) return(1);
	cook_yes();
	cook_init_data();
	
	logf("*** PSEUDO DATA MODE ***\n");
	timer_start = 0xffffffff;
	while(1) {
		n = beread(in_embla_fd, &sz, 4);
		if (n == 1) {
			logf("*** EOF -- OK ***\n");
			cook_stop_data();
			return(0);
		} else if (n) return(1);
		if (bread(in_embla_fd, &t, 4)) return(1);
		if (sz < 0) { dev = 1; sz = -sz; }
		else dev = 0;
		if (sz > sizeof(buff)) {
			PE("Error on file (%d-bytes-buffer)\n", sz);
			return(1);
		}
		if (bread(in_embla_fd, buff, sz)) return(1);
		log_data(dev, 0, buff, sz);
		
		if (timer_start == 0xffffffff) {
			timer_start = timer_ms();
			timer_cur = 0;
		} else	timer_cur = timer_ms() - timer_start;
		if (dev) {
			if (timer_cur < t) sleep_ms(t - timer_cur);
			else if (timer_cur > t)
				logf("Warning: pseudo packet delayed (%dms)\n",
					timer_cur-t);
			cook_data(buff, sz);
		}
	}
}
